/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.util;

import java.util.List;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.list.ShortNameListCellRenderer;
import org.openvpms.web.component.im.list.ShortNameListModel;
import org.openvpms.web.component.im.util.IMObjectCreatorListener;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.SelectionDialog;
import org.openvpms.web.echo.factory.ListBoxFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public final class IMObjectCreator {
    private IMObjectCreator() {
    }

    public static org.openvpms.component.model.object.IMObject create(String shortName) {
        IMObject result = null;
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        try {
            if (IMObjectCreator.canCreate(shortName, (IArchetypeService)service) && (result = service.create(shortName)) == null) {
                IMObjectCreator.showArchetypeNotFound(shortName);
            }
        }
        catch (OpenVPMSException exception) {
            String displayName = null;
            try {
                displayName = DescriptorHelper.getDisplayName((String)shortName, (ArchetypeService)service);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (displayName == null) {
                displayName = shortName;
            }
            String title = Messages.format((String)"imobject.create.failed", (Object[])new Object[]{displayName});
            ErrorHelper.show(title, exception);
        }
        return result;
    }

    public static void create(String type, List<String> shortNames, IMObjectCreatorListener listener, HelpContext help) {
        IMObjectCreator.create(type, shortNames.toArray(new String[0]), listener, help);
    }

    public static void create(String type, String[] shortNames, IMObjectCreatorListener listener, HelpContext help) {
        IMObjectCreator.create(type, shortNames, null, listener, help);
    }

    public static void create(Archetypes<?> archetypes, IMObjectCreatorListener listener, HelpContext help) {
        IMObjectCreator.create(archetypes.getDisplayName(), archetypes.getShortNames(), archetypes.getDefaultShortName(), listener, help);
    }

    public static void create(String type, String[] shortNames, String defaultShortName, final IMObjectCreatorListener listener, HelpContext help) {
        if ((shortNames = DescriptorHelper.getShortNames((String[])shortNames, (ArchetypeService)ServiceHelper.getArchetypeService())).length == 0) {
            String title = Messages.get((String)"imobject.create.noshortnames");
            ErrorHelper.show(title, type);
            listener.cancelled();
        } else if (shortNames.length > 1) {
            int index;
            final ShortNameListModel model = new ShortNameListModel(shortNames, false);
            String title = Messages.format((String)"imobject.create.title", (Object[])new Object[]{type});
            String message = Messages.format((String)"imobject.create.message", (Object[])new Object[]{type});
            ListBox list = ListBoxFactory.create((ListModel)model);
            int height = StyleSheetHelper.getProperty((String)"SelectionDialog.list.height", (int)-1);
            if (height != -1) {
                list.setHeight(new Extent(height, 1));
            } else {
                list.setHeight(new Extent(12, 64));
            }
            list.setCellRenderer((ListCellRenderer)new ShortNameListCellRenderer());
            if (defaultShortName != null && (index = model.indexOf(defaultShortName)) != -1) {
                list.setSelectedIndex(index);
            }
            final SelectionDialog dialog = new SelectionDialog(title, message, list, help);
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    int selected = dialog.getSelectedIndex();
                    if (selected != -1) {
                        org.openvpms.component.model.object.IMObject object = IMObjectCreator.create(model.getShortName(selected));
                        if (object != null) {
                            listener.created(object);
                        } else {
                            listener.cancelled();
                        }
                    }
                }
            });
            dialog.show();
        } else {
            org.openvpms.component.model.object.IMObject object = IMObjectCreator.create(shortNames[0]);
            if (object != null) {
                listener.created(object);
            } else {
                listener.cancelled();
            }
        }
    }

    private static boolean canCreate(String archetype, IArchetypeService service) {
        boolean result = false;
        ArchetypeDescriptor descriptor = service.getArchetypeDescriptor(archetype);
        if (descriptor != null) {
            if (descriptor.isSingleton()) {
                if (IMObjectHelper.hasActiveInstance(archetype)) {
                    String title = Messages.get((String)"imobject.create.failed.title");
                    String message = Messages.format((String)"imobject.create.singleton", (Object[])new Object[]{descriptor.getDisplayName()});
                    ErrorHelper.show(title, message);
                } else {
                    result = true;
                }
            } else {
                result = true;
            }
        } else {
            IMObjectCreator.showArchetypeNotFound(archetype);
        }
        return result;
    }

    private static void showArchetypeNotFound(String archetype) {
        String title = Messages.get((String)"imobject.create.failed.title");
        String message = Messages.format((String)"imobject.create.noarchetype", (Object[])new Object[]{archetype});
        ErrorHelper.show(title, message);
    }
}

