/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.util;

import java.util.Collection;
import org.hibernate.ObjectNotFoundException;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.error.ExceptionHelper;
import org.openvpms.web.component.im.util.IMObjectSaveListener;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIMObjectSaveListener
implements IMObjectSaveListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractIMObjectSaveListener.class);

    @Override
    public void saved(Collection<? extends IMObject> objects) {
    }

    public void error(IMObject object, Throwable exception) {
        String displayName = DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)ServiceHelper.getArchetypeService());
        String context = Messages.format((String)"imobject.save.failed", (Object[])new Object[]{object.getObjectReference()});
        this.error(displayName, context, exception);
    }

    @Override
    public void error(Collection<? extends IMObject> objects, Throwable exception) {
        IMObject object = objects.toArray(new IMObject[0])[0];
        this.error(object, exception);
    }

    protected void onErrorClosed() {
    }

    private void error(String displayName, String context, Throwable exception) {
        Throwable cause = ExceptionHelper.getRootCause(exception);
        String title = Messages.format((String)"imobject.save.failed", (Object[])new Object[]{displayName});
        if (cause instanceof ObjectNotFoundException) {
            String message = Messages.format((String)"imobject.notfound", (Object[])new Object[]{displayName});
            log.error(message, exception);
            ErrorHandler.getInstance().error(title, message, null, this::onErrorClosed);
        } else {
            String message;
            String logerror = message = ErrorFormatter.format(exception, displayName);
            if (context != null) {
                logerror = Messages.format((String)"logging.error.messageandcontext", (Object[])new Object[]{message, context});
            }
            log.error(logerror, exception);
            ErrorHandler.getInstance().error(title, message, exception, this::onErrorClosed);
        }
    }
}

