/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table.act;

import java.math.BigDecimal;
import java.util.Date;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.table.BaseIMObjectTableModel;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.resource.i18n.format.NumberFormatter;

public class ActAmountTableModel<T extends Act>
extends BaseIMObjectTableModel<T> {
    protected static final int DATE_INDEX = 6;
    protected static final int STATUS_INDEX = 7;
    protected static final int AMOUNT_INDEX = 8;
    private final boolean negateAmount;

    public ActAmountTableModel() {
        this(true, false);
    }

    public ActAmountTableModel(boolean showStatus, boolean showAmount) {
        this(true, showStatus, showAmount);
    }

    public ActAmountTableModel(boolean showArchetype, boolean showStatus, boolean showAmount) {
        this(showArchetype, showStatus, showAmount, false, true);
    }

    public ActAmountTableModel(boolean showArchetype, boolean showStatus, boolean showAmount, boolean negateAmount, boolean showDescription) {
        super(null);
        this.setTableColumnModel(this.createColumnModel(showArchetype, showStatus, showAmount, showDescription));
        this.negateAmount = negateAmount;
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        SortConstraint[] result;
        switch (column) {
            case 1: {
                result = new SortConstraint[]{new NodeSortConstraint("id", ascending)};
                break;
            }
            case 6: {
                result = new SortConstraint[]{new NodeSortConstraint("startTime", ascending)};
                break;
            }
            case 7: {
                result = new SortConstraint[]{new NodeSortConstraint("status", ascending)};
                break;
            }
            case 8: {
                result = new SortConstraint[]{new NodeSortConstraint("amount", ascending)};
                break;
            }
            default: {
                result = super.getSortConstraints(column, ascending);
            }
        }
        return result;
    }

    protected TableColumnModel createColumnModel(boolean showArchetype, boolean showStatus, boolean showAmount, boolean showDescription) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(ActAmountTableModel.createTableColumn(1, "table.imobject.id"));
        model.addColumn(ActAmountTableModel.createTableColumn(6, "table.act.date"));
        if (showArchetype) {
            model.addColumn(ActAmountTableModel.createTableColumn(2, "table.act.type"));
        }
        if (showStatus) {
            model.addColumn(ActAmountTableModel.createTableColumn(7, "table.act.status"));
        }
        if (showAmount) {
            model.addColumn(ActAmountTableModel.createTableColumn(8, "table.act.amount"));
        }
        if (showDescription) {
            model.addColumn(ActAmountTableModel.createTableColumn(4, "table.act.description"));
        }
        return model;
    }

    @Override
    protected Object getValue(T act, TableColumn column, int row) {
        Object result = null;
        switch (column.getModelIndex()) {
            case 6: {
                Date date = act.getActivityStartTime();
                if (date == null) break;
                result = DateFormatter.formatDate((Date)date, (boolean)false);
                break;
            }
            case 7: {
                result = this.getStatus((Act)act);
                break;
            }
            case 8: {
                result = this.getAmount((Act)act);
                break;
            }
            default: {
                result = super.getValue(act, column, row);
            }
        }
        return result;
    }

    @Override
    protected int getNextModelIndex(TableColumnModel columns) {
        return super.getNextModelIndex(columns, 9);
    }

    protected Label getAmount(Act act) {
        BigDecimal amount = ActHelper.getAmount(act, "amount");
        if (this.negateAmount) {
            amount = amount.negate();
        }
        String result = NumberFormatter.format((Number)amount);
        return TableHelper.rightAlign((String)result);
    }

    protected String getStatus(Act act) {
        String result = LookupNameHelper.getName((IMObject)act, "status");
        if (result == null) {
            result = act.getStatus();
        }
        return result;
    }
}

