/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.DelegatingIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.echo.table.PageableTableModel;
import org.openvpms.web.echo.table.SortableTableModel;

public class PagedIMTableModel<T, K>
extends DelegatingIMTableModel<T, K>
implements PageableTableModel,
SortableTableModel {
    private ResultSet<T> set;
    private int page;
    private int sortColumn = -1;
    private int defaultSortColumn;
    private boolean defaultSortAscending;

    public PagedIMTableModel(IMTableModel<K> model) {
        this.setModel(model);
    }

    public void setResultSet(ResultSet<T> set) {
        this.set = set;
        this.sortColumn = -1;
        SortConstraint[] sorted = set.getSortConstraints();
        Iterator iter = this.getModel().getColumnModel().getColumns();
        if (sorted.length != 0) {
            while (iter.hasNext()) {
                TableColumn column = (TableColumn)iter.next();
                SortConstraint[] columnConstraint = this.getModel().getSortConstraints(column.getModelIndex(), set.isSortedAscending());
                boolean match = true;
                if (columnConstraint != null && sorted.length == columnConstraint.length) {
                    for (int i = 0; i < sorted.length; ++i) {
                        if (sorted[i].equals((Object)columnConstraint[i])) continue;
                        match = false;
                        break;
                    }
                } else {
                    match = false;
                }
                if (!match) continue;
                this.sortColumn = column.getModelIndex();
                break;
            }
        }
        if (!this.setPage(0)) {
            this.page = 0;
            List objects = Collections.emptyList();
            this.setPage(objects);
        }
    }

    public ResultSet<T> getResultSet() {
        return this.set;
    }

    public boolean hasPage(int page) {
        return this.set.getPage(page) != null;
    }

    public boolean setPage(int page) {
        IPage<T> result = this.set.getPage(page);
        if (result != null) {
            this.page = page;
            this.setPage(result.getResults());
            return true;
        }
        return false;
    }

    public int getPage() {
        return this.page;
    }

    public int getPages() {
        return this.set.getPages();
    }

    public int getEstimatedPages() {
        return this.set.getEstimatedPages();
    }

    public boolean isEstimatedActual() {
        return this.set.isEstimatedActual();
    }

    public int getRowsPerPage() {
        return this.set.getPageSize();
    }

    public int getResults() {
        return this.set.getResults();
    }

    public int getResults(boolean force) {
        return this.set.getEstimatedResults();
    }

    @Override
    public void setObjects(List<T> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setModel(IMTableModel<K> model) {
        this.defaultSortColumn = model.getDefaultSortColumn();
        this.defaultSortAscending = model.getDefaultSortAscending();
        super.setModel(model);
        if (this.defaultSortColumn == -1) {
            Iterator iter = model.getColumnModel().getColumns();
            while (iter.hasNext()) {
                TableColumn column = (TableColumn)iter.next();
                if (!this.isSortable(column.getModelIndex())) continue;
                this.defaultSortColumn = column.getModelIndex();
                this.defaultSortAscending = true;
                break;
            }
        }
    }

    public void sort(int column, boolean ascending) {
        SortConstraint[] criteria = this.getSortConstraints(column, ascending);
        this.sortColumn = column;
        this.set.sort(criteria);
        this.setPage(0);
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public int getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    @Override
    public boolean getDefaultSortAscending() {
        return this.defaultSortAscending;
    }

    public boolean isSortable(int column) {
        SortConstraint[] sort = this.getModel().getSortConstraints(column, true);
        return sort != null && sort.length != 0;
    }

    public boolean isSorted() {
        return this.set.getSortConstraints().length != 0;
    }

    public boolean isSortedAscending() {
        return this.set.isSortedAscending();
    }

    protected void setPage(List<T> objects) {
        this.getModel().setObjects(this.convertTo(objects));
    }
}

