/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.TableCellRenderer;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTableModel;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.table.PageListener;
import org.openvpms.web.echo.table.SortableTableHeaderRenderer;
import org.openvpms.web.echo.table.TableNavigator;
import org.openvpms.web.echo.util.StyleSheetHelper;

public class PagedIMTable<T> {
    private final IMTable<T> table;
    private final Container container;
    private TableNavigator navigator;
    private FocusGroup group = new FocusGroup(PagedIMTable.class.getSimpleName());
    private static final Extent ZERO_PX = new Extent(0);

    public PagedIMTable(IMTableModel<T> model) {
        this(model, false);
    }

    public PagedIMTable(IMTableModel<T> model, ResultSet<T> set) {
        this(model);
        this.setResultSet(set);
    }

    public PagedIMTable(IMTableModel<T> model, boolean useSplitPane) {
        this.container = useSplitPane ? new SplitPaneContainer() : new DefaultContainer();
        IMTableModel<T> paged = !(model instanceof PagedIMTableModel) ? new PagedIMTableModel(model) : model;
        this.table = new IMTable<T>(paged);
        this.table.setDefaultHeaderRenderer((TableCellRenderer)new SortableTableHeaderRenderer());
        this.table.setRolloverEnabled(false);
        this.table.setHeaderFixed(true);
        this.table.addPageListener(new PageListener(){

            public void onAction(ActionEvent event) {
                PagedIMTable.this.doPage(event);
            }
        });
        this.group.add(this.table);
        this.container.setTable(this.table);
    }

    public void setResultSet(ResultSet<T> set) {
        PagedIMTableModel<T, T> model = this.getModel();
        model.setResultSet(set);
        int pages = set.getEstimatedPages();
        boolean actual = set.isEstimatedActual();
        if (this.navigator == null) {
            this.navigator = new TableNavigator(this.table);
            this.container.setNavigator(this.navigator);
            this.group.add(0, (Component)this.navigator);
        }
        if (!actual && pages > 0 || pages > 1) {
            this.container.showNavigator(true);
        } else {
            this.container.showNavigator(false);
        }
    }

    public T getSelected() {
        return this.table.getSelected();
    }

    public void setSelected(T object) {
        this.table.setSelected(object);
    }

    public ResultSet<T> getResultSet() {
        return this.getModel().getResultSet();
    }

    public IMTable<T> getTable() {
        return this.table;
    }

    public PagedIMTableModel<T, T> getModel() {
        return (PagedIMTableModel)this.table.getModel();
    }

    public int getPage() {
        return this.getModel().getPage();
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public Component getComponent() {
        return this.container.getComponent();
    }

    public FocusGroup getFocusGroup() {
        return this.group;
    }

    private void doPage(ActionEvent event) {
        if (this.navigator != null) {
            int rows;
            String key = event.getActionCommand();
            if ("previous".equals(key)) {
                this.navigator.previous();
            } else if ("next".equals(key) || "next-top".equals(key)) {
                this.navigator.next();
            } else if ("first".equals(key)) {
                this.navigator.first();
            } else if ("last".equals(key)) {
                this.navigator.last();
            } else if ("previous-bottom".equals(key) && this.navigator.previous() && (rows = this.table.getModel().getRowCount()) > 0) {
                this.table.getSelectionModel().setSelectedIndex(rows - 1, true);
            }
            FocusHelper.setFocus(this.table);
        }
    }

    private class SplitPaneContainer
    implements Container {
        private final SplitPane container = SplitPaneFactory.create((int)5, (String)"PagedIMTable", (Component[])new Component[0]);
        private Extent position = this.container.getSeparatorPosition();

        SplitPaneContainer() {
            if (this.position == null && this.container.getStyleName() != null) {
                this.position = StyleSheetHelper.getExtent(SplitPane.class, (String)this.container.getStyleName(), (String)"separatorPosition");
            }
            this.container.add((Component)LabelFactory.create());
        }

        @Override
        public void setTable(IMTable table) {
            this.container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{table}));
        }

        @Override
        public void setNavigator(TableNavigator navigator) {
            if (this.container.getComponentCount() == 2) {
                this.container.remove(0);
            }
            this.container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{navigator}), 0);
        }

        @Override
        public void showNavigator(boolean show) {
            this.container.setSeparatorPosition(show ? this.position : ZERO_PX);
        }

        @Override
        public Component getComponent() {
            return this.container;
        }
    }

    private class DefaultContainer
    implements Container {
        private final Component container;
        private final Column navigatorContainer = ColumnFactory.create((String)"Inset");

        DefaultContainer() {
            this.navigatorContainer.setVisible(false);
            this.container = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{this.navigatorContainer});
        }

        @Override
        public void setTable(IMTable table) {
            this.container.add((Component)table);
        }

        @Override
        public void setNavigator(TableNavigator navigator) {
            this.navigatorContainer.add((Component)navigator);
        }

        @Override
        public void showNavigator(boolean show) {
            this.navigatorContainer.setVisible(show);
        }

        @Override
        public Component getComponent() {
            return this.container;
        }
    }

    private static interface Container {
        public void setTable(IMTable var1);

        public void setNavigator(TableNavigator var1);

        public void showNavigator(boolean var1);

        public Component getComponent();
    }
}

