/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.BaseIMObjectTableModel;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.echo.factory.LabelFactory;

public abstract class DescriptorTableModel<T extends IMObject>
extends BaseIMObjectTableModel<T> {
    private final LayoutContext context;
    private List<ArchetypeDescriptor> archetypes;
    private IMObjectBean current;

    public DescriptorTableModel(LayoutContext context) {
        super(null);
        if (!(context.getComponentFactory() instanceof TableComponentFactory)) {
            context = new DefaultLayoutContext(context);
            context.setComponentFactory(new TableComponentFactory(context));
        }
        this.context = context;
    }

    public DescriptorTableModel(String[] shortNames, LayoutContext context) {
        this(context);
        this.setTableColumnModel(this.createColumnModel(shortNames, this.context));
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        DescriptorTableColumn descCol;
        List<SortConstraint> list;
        TableColumn col = this.getColumn(column);
        SortConstraint[] result = col instanceof DescriptorTableColumn ? ((list = this.getSortConstraints(descCol = (DescriptorTableColumn)col, ascending)) != null ? list.toArray(new SortConstraint[0]) : null) : super.getSortConstraints(column, ascending);
        return result;
    }

    public DescriptorTableColumn getColumn(String name) {
        return this.getColumn(this.getColumnModel(), name);
    }

    @Override
    public void postRender() {
        super.postRender();
        this.current = null;
    }

    protected List<SortConstraint> getSortConstraints(DescriptorTableColumn primary, boolean ascending) {
        if (!primary.isSortable()) {
            return null;
        }
        if (primary.getName().equals("description")) {
            return this.getSortConstraints(primary, ascending, "name", "id");
        }
        return this.getSortConstraints(primary, ascending, "description", "id");
    }

    protected List<SortConstraint> getSortConstraints(DescriptorTableColumn primary, boolean ascending, String ... names) {
        ArrayList<SortConstraint> result = new ArrayList<SortConstraint>();
        result.add(primary.createSortConstraint(ascending));
        for (String name : names) {
            DescriptorTableColumn column = this.getColumn(name);
            if (column != null && column.isSortable()) {
                result.add(column.createSortConstraint(ascending));
                continue;
            }
            if (column != null || this.archetypes == null) continue;
            boolean found = true;
            for (ArchetypeDescriptor archetype : this.archetypes) {
                if (archetype.getNodeDescriptor(name) != null) continue;
                found = false;
                break;
            }
            if (!found) continue;
            result.add((SortConstraint)new NodeSortConstraint(name, ascending));
        }
        return result;
    }

    @Override
    protected Object getValue(T object, TableColumn column, int row) {
        Object result = column instanceof DescriptorTableColumn ? this.getValue(object, (DescriptorTableColumn)column, row) : super.getValue(object, column, row);
        return result;
    }

    protected Object getValue(T object, DescriptorTableColumn column, int row) {
        return column.getComponent((IMObject)object, this.context);
    }

    protected LayoutContext getLayoutContext() {
        return this.context;
    }

    protected TableColumnModel createColumnModel(String[] shortNames, LayoutContext context) {
        List archetypes = DescriptorHelper.getArchetypeDescriptors((String[])shortNames, (ArchetypeService)this.getService());
        if (archetypes.isEmpty()) {
            throw new IllegalArgumentException("Argument 'shortNames' doesn't refer to a valid archetype: " + StringUtils.join((Object[])shortNames, (String)", "));
        }
        return this.createColumnModel(archetypes, context);
    }

    protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        this.archetypes = archetypes;
        List<String> names = this.getNodeNames(archetypes, context);
        DefaultTableColumnModel columns = new DefaultTableColumnModel();
        int idIndex = names.indexOf("id");
        if (idIndex != -1) {
            if (!(names instanceof ArrayList)) {
                names = new ArrayList<String>(names);
            }
            names.remove(idIndex);
            TableColumn column = DescriptorTableModel.createTableColumn(1, "table.imobject.id");
            columns.addColumn(column);
        }
        if (this.showArchetypeColumn(archetypes)) {
            this.addColumns(archetypes, names, (TableColumnModel)columns);
            int index = this.getArchetypeColumnIndex(idIndex != -1);
            TableColumn column = DescriptorTableModel.createTableColumn(2, "table.imobject.archetype");
            columns.addColumn(column);
            columns.moveColumn(columns.getColumnCount() - 1, index);
        } else {
            this.addColumns(archetypes, names, (TableColumnModel)columns);
        }
        return columns;
    }

    protected void addColumns(List<ArchetypeDescriptor> archetypes, List<String> names, TableColumnModel columns) {
        int index = this.getNextModelIndex(columns);
        for (String name : names) {
            this.addColumn(archetypes, name, index, columns);
            ++index;
        }
    }

    protected TableColumn addColumn(ArchetypeDescriptor archetype, String name, TableColumnModel columns) {
        return this.addColumn(Collections.singletonList(archetype), name, this.getNextModelIndex(columns), columns);
    }

    protected TableColumn addColumn(List<ArchetypeDescriptor> archetypes, String name, int index, TableColumnModel columns) {
        TableColumn column = this.createColumn(archetypes, name, index);
        columns.addColumn(column);
        return column;
    }

    protected TableColumn createColumn(List<ArchetypeDescriptor> archetypes, String name, int index) {
        return new DescriptorTableColumn(index, name, archetypes);
    }

    protected int getColumnOffset(TableColumnModel model, String name) {
        int result = -1;
        int offset = 0;
        Iterator iterator = model.getColumns();
        while (iterator.hasNext()) {
            DescriptorTableColumn descriptorCol;
            TableColumn col = (TableColumn)iterator.next();
            if (col instanceof DescriptorTableColumn && (descriptorCol = (DescriptorTableColumn)col).getName().equals(name)) {
                result = offset;
                break;
            }
            ++offset;
        }
        return result;
    }

    protected DescriptorTableColumn getColumn(TableColumnModel model, String name) {
        Iterator iterator = model.getColumns();
        while (iterator.hasNext()) {
            DescriptorTableColumn descriptorCol;
            TableColumn col = (TableColumn)iterator.next();
            if (!(col instanceof DescriptorTableColumn) || !(descriptorCol = (DescriptorTableColumn)col).getName().equals(name)) continue;
            return descriptorCol;
        }
        return null;
    }

    protected int getModelIndex(TableColumnModel model, String name) {
        DescriptorTableColumn column = this.getColumn(model, name);
        return column != null ? column.getModelIndex() : -1;
    }

    protected List<String> getNodeNames(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        List<String> result;
        String[] names = this.getNodeNames();
        if (names != null && names.length != 0) {
            result = Arrays.asList(names);
        } else {
            ArchetypeNodes nodes = this.getArchetypeNodes();
            result = nodes.getNodeNames(archetypes);
        }
        return result;
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return this.allSimpleNodesMinusIdAndLongText();
    }

    protected ArchetypeNodes allSimpleNodesMinusIdAndLongText() {
        return ArchetypeNodes.allSimple().excludeStringLongerThan(255L).exclude("id").excludePassword(true);
    }

    protected String[] getNodeNames() {
        return null;
    }

    protected boolean showArchetypeColumn(List<ArchetypeDescriptor> archetypes) {
        return archetypes.size() > 1;
    }

    protected int getArchetypeColumnIndex(boolean showId) {
        return showId ? 1 : 0;
    }

    protected IMObjectBean getCurrent(IMObject object) {
        if (this.current == null || !this.current.getObject().equals(object)) {
            this.initCurrent(object);
        }
        return this.current;
    }

    protected IMObjectBean initCurrent(IMObject object) {
        this.current = this.getBean(object);
        return this.current;
    }

    protected Label getTruncatedValue(IMObject object, DescriptorTableColumn column, int maxLength) {
        Object value = column.getValue(object);
        Label result = value != null ? this.getTruncatedValue(value.toString(), maxLength) : new Label();
        return result;
    }

    protected Label getTruncatedValue(String value, int maxLength) {
        return LabelFactory.text((String)StringUtils.abbreviate((String)value, (int)maxLength));
    }

    protected Component createViewer(Act object, String node, boolean link) {
        IMObjectBean current = this.getCurrent((IMObject)object);
        Reference reference = current.getTargetRef(node);
        return reference != null ? this.createViewer(reference, link) : null;
    }

    protected Component createViewer(Reference reference, boolean link) {
        String name = this.getLayoutContext().getNames().getName(reference);
        return this.createViewer(reference, name, link);
    }

    protected Component createViewer(Reference reference, String name, boolean link) {
        LayoutContext context = this.getLayoutContext();
        ContextSwitchListener listener = link ? context.getContextSwitchListener() : null;
        IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(reference, name, listener, context.getContext());
        return viewer.getComponent();
    }
}

