/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.view.Hint;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.DelegatingProperty;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorTableColumn
extends TableColumn {
    private final String name;
    private final Map<String, NodeDescriptor> descriptors = new HashMap<String, NodeDescriptor>();
    private final boolean commonNode;
    private Object defaultValue;
    private Hint hint;
    private static final Logger log = LoggerFactory.getLogger(DescriptorTableColumn.class);

    public DescriptorTableColumn(int modelIndex, String name, List<ArchetypeDescriptor> archetypes) {
        this(modelIndex, name, null, archetypes);
    }

    public DescriptorTableColumn(int modelIndex, String name, Object defaultValue, List<ArchetypeDescriptor> archetypes) {
        this(modelIndex, name, defaultValue, null, archetypes);
    }

    public DescriptorTableColumn(int modelIndex, String name, Object defaultValue, Hint hint, List<ArchetypeDescriptor> archetypes) {
        super(modelIndex);
        boolean found = true;
        for (ArchetypeDescriptor archetype : archetypes) {
            NodeDescriptor descriptor = (NodeDescriptor)archetype.getNodeDescriptor(name);
            if (descriptor != null) {
                this.descriptors.put(archetype.getArchetypeType(), descriptor);
                if (this.getHeaderValue() != null) continue;
                this.setHeaderValue(descriptor.getDisplayName());
                continue;
            }
            found = false;
        }
        this.name = name;
        this.commonNode = found;
        this.hint = hint;
        this.defaultValue = defaultValue;
    }

    public DescriptorTableColumn(int modelIndex, String name, ArchetypeDescriptor archetype) {
        this(modelIndex, name, null, archetype);
    }

    public DescriptorTableColumn(int modelIndex, String name, Object defaultValue, ArchetypeDescriptor archetype) {
        super(modelIndex);
        NodeDescriptor descriptor = (NodeDescriptor)archetype.getNodeDescriptor(name);
        if (descriptor != null) {
            this.descriptors.put(archetype.getArchetypeType(), descriptor);
            this.setHeaderValue(descriptor.getDisplayName());
        }
        this.name = name;
        this.commonNode = descriptor != null;
        this.defaultValue = defaultValue;
    }

    public Object getValue(IMObject object) {
        Object result = null;
        NodeDescriptor node = this.getDescriptor(object);
        if (node != null && (result = node.getValue(object)) == null) {
            result = this.defaultValue;
        }
        return result;
    }

    public List<IMObject> getValues(IMObject object) {
        NodeDescriptor node = this.getDescriptor(object);
        return node != null ? node.getValues(object) : null;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setHint(Hint hint) {
        this.hint = hint;
    }

    public Component getComponent(IMObject object, LayoutContext context) {
        Component result = null;
        try {
            NodeDescriptor node = this.getDescriptor(object);
            if (node != null) {
                IMObjectComponentFactory factory = context.getComponentFactory();
                Property property = this.getProperty(object, node);
                result = factory.create(property, object, this.hint).getComponent();
            }
        }
        catch (Exception exception) {
            log.error("Failed to render node={} for {}: {}", new Object[]{this.name, object.getObjectReference(), exception.getMessage(), exception});
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSortable() {
        boolean sortable = this.commonNode;
        if (sortable) {
            for (NodeDescriptor descriptor : this.descriptors.values()) {
                if (descriptor.isCollection() && !QueryHelper.isParticipationNode(descriptor)) {
                    sortable = false;
                    break;
                }
                if (descriptor.getPath().lastIndexOf("/") <= 0) continue;
                sortable = false;
                break;
            }
        }
        return sortable;
    }

    public SortConstraint createSortConstraint(boolean ascending) {
        return new NodeSortConstraint(this.name, ascending);
    }

    protected Property getProperty(IMObject object, NodeDescriptor node) {
        CollectionProperty property = new IMObjectProperty(object, (org.openvpms.component.model.archetype.NodeDescriptor)node);
        if (this.defaultValue != null) {
            property = new DelegatingProperty(property){

                @Override
                public Object getValue() {
                    Object value = super.getValue();
                    return value == null ? DescriptorTableColumn.this.defaultValue : value;
                }
            };
        }
        return property;
    }

    protected NodeDescriptor getDescriptor(IMObject object) {
        return this.descriptors.get(object.getArchetype());
    }
}

