/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ArchetypeSortConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.table.AbstractIMObjectTableModel;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;

public abstract class BaseIMObjectTableModel<T extends IMObject>
extends AbstractIMObjectTableModel<T> {
    public static final int ID_INDEX = 1;
    public static final int ARCHETYPE_INDEX = 2;
    public static final int NAME_INDEX = 3;
    public static final int DESCRIPTION_INDEX = 4;
    public static final int ACTIVE_INDEX = 5;
    public static final int NEXT_INDEX = 6;

    public BaseIMObjectTableModel() {
        this.setTableColumnModel(this.createTableColumnModel());
    }

    public BaseIMObjectTableModel(TableColumnModel model) {
        super(model);
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        SortConstraint[] result;
        switch (column) {
            case 1: {
                NodeSortConstraint id = new NodeSortConstraint("id", ascending);
                result = new SortConstraint[]{id};
                break;
            }
            case 2: {
                ArchetypeSortConstraint archetype = new ArchetypeSortConstraint(ascending);
                result = new SortConstraint[]{archetype};
                break;
            }
            case 3: {
                NodeSortConstraint name = new NodeSortConstraint("name", ascending);
                result = new SortConstraint[]{name};
                break;
            }
            case 4: {
                NodeSortConstraint description = new NodeSortConstraint("description", ascending);
                result = new SortConstraint[]{description};
                break;
            }
            case 5: {
                NodeSortConstraint active = new NodeSortConstraint("active", ascending);
                result = new SortConstraint[]{active};
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    protected TableColumnModel createTableColumnModel() {
        return this.createTableColumnModel(false);
    }

    protected TableColumnModel createTableColumnModel(boolean showArchetype) {
        return this.createTableColumnModel(false, showArchetype);
    }

    protected TableColumnModel createTableColumnModel(boolean showId, boolean showArchetype) {
        return this.createTableColumnModel(showId, showArchetype, false);
    }

    protected TableColumnModel createTableColumnModel(boolean showId, boolean showArchetype, boolean showActive) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        return this.createTableColumnModel(showId, showArchetype, showActive, (TableColumnModel)model);
    }

    protected TableColumnModel createTableColumnModel(boolean showId, boolean showArchetype, boolean showName, boolean showDescription, boolean showActive) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        return this.createTableColumnModel(showId, showArchetype, showName, showDescription, showActive, (TableColumnModel)model);
    }

    protected TableColumnModel createTableColumnModel(boolean showId, boolean showArchetype, TableColumnModel model) {
        return this.createTableColumnModel(showId, showArchetype, false, model);
    }

    protected TableColumnModel createTableColumnModel(boolean showId, boolean showArchetype, boolean showActive, TableColumnModel model) {
        return this.createTableColumnModel(showId, showArchetype, true, true, showActive, model);
    }

    protected TableColumnModel createTableColumnModel(boolean showId, boolean showArchetype, boolean showName, boolean showDescription, boolean showActive, TableColumnModel model) {
        if (showId) {
            model.addColumn(BaseIMObjectTableModel.createTableColumn(1, "table.imobject.id"));
        }
        if (showArchetype) {
            model.addColumn(BaseIMObjectTableModel.createTableColumn(2, "table.imobject.archetype"));
        }
        if (showName) {
            model.addColumn(BaseIMObjectTableModel.createTableColumn(3, "table.imobject.name"));
        }
        if (showDescription) {
            model.addColumn(BaseIMObjectTableModel.createTableColumn(4, "table.imobject.description"));
        }
        if (showActive) {
            model.addColumn(BaseIMObjectTableModel.createTableColumn(5, "table.imobject.active"));
        }
        return model;
    }

    @Override
    protected Object getValue(T object, TableColumn column, int row) {
        Object result;
        switch (column.getModelIndex()) {
            case 0: {
                result = this.getRowMark(row);
                break;
            }
            case 1: {
                result = object.getId();
                break;
            }
            case 2: {
                result = this.getDisplayName((IMObject)object);
                break;
            }
            case 3: {
                result = object.getName();
                if (result != null) break;
                Label label = LabelFactory.create();
                label.setText(Messages.get((String)"imobject.none"));
                result = label;
                break;
            }
            case 4: {
                result = this.getDescription(object);
                break;
            }
            case 5: {
                CheckBox active = new CheckBox();
                active.setEnabled(false);
                active.setSelected(object.isActive());
                result = active;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal column=" + column);
            }
        }
        return result;
    }

    protected String getDescription(T object) {
        return object.getDescription();
    }

    @Override
    protected int getNextModelIndex(TableColumnModel columns) {
        return this.getNextModelIndex(columns, 6);
    }
}

