/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;

public class SelectedObjects<T extends IMObject> {
    private final List<String> names = new ArrayList<String>();
    private List<T> objects = new ArrayList<T>();

    public void setObjects(List<T> objects) {
        this.names.clear();
        this.objects.clear();
        for (IMObject object : objects) {
            this.addObject(object);
        }
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<T> getObjects() {
        return this.objects;
    }

    public void addObject(T object) {
        this.setObject(this.objects.size(), object);
    }

    public void addObjects(T ... objects) {
        for (T object : objects) {
            this.addObject(object);
        }
    }

    public void setObject(int index, T object) {
        if (index < this.objects.size()) {
            this.objects.set(index, object);
            this.names.set(index, this.getName(object));
        } else {
            this.objects.add(index, object);
            this.names.add(index, this.getName(object));
        }
    }

    public int size() {
        return this.objects.size();
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (String name : this.names) {
            buffer.append(name);
            buffer.append("; ");
        }
        return buffer.toString();
    }

    public String getFirstNotFound() {
        String result = null;
        for (int i = 0; i < this.names.size() && i < this.objects.size(); ++i) {
            String name = this.names.get(i);
            IMObject object = (IMObject)this.objects.get(i);
            if (object != null && this.matches(name, object, false)) continue;
            result = name == null ? "" : name;
        }
        return result;
    }

    public boolean isValid() {
        boolean valid = false;
        if (this.names.size() == this.objects.size()) {
            valid = this.getFirstNotFound() == null;
        }
        return valid;
    }

    public void parseNames(String text) {
        this.setNames(this.parse(text));
    }

    public void setNames(String ... names) {
        this.names.clear();
        this.names.addAll(Arrays.asList(names));
        ArrayList<T> newObjects = new ArrayList<T>();
        int last = 0;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int index = this.indexOf(name, last);
            if (index != -1) {
                for (int j = newObjects.size(); j < i; ++j) {
                    newObjects.add(null);
                }
                newObjects.add(this.objects.get(index));
                last = index;
                continue;
            }
            newObjects.add(null);
        }
        this.objects = newObjects;
    }

    public void clear() {
        this.names.clear();
        this.objects.clear();
    }

    public boolean haveMatch(int index) {
        IMObject object = (IMObject)this.objects.get(index);
        return object != null && this.matches(this.names.get(index), object, false);
    }

    protected String getName(T object) {
        return object.getName();
    }

    protected boolean matches(String name, T object, boolean ignoreCase) {
        return ignoreCase ? StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)object.getName()) : StringUtils.equals((CharSequence)name, (CharSequence)object.getName());
    }

    private int indexOf(String name, int start) {
        for (int i = start; i < this.objects.size(); ++i) {
            IMObject object = (IMObject)this.objects.get(i);
            if (object == null || !this.matches(name, object, true)) continue;
            return i;
        }
        return -1;
    }

    private String[] parse(String names) {
        String[] result;
        if (names != null) {
            String[] split;
            ArrayList<String> parsed = new ArrayList<String>();
            for (String aSplit : split = names.split(";")) {
                String name = aSplit.trim();
                if (name.isEmpty()) continue;
                parsed.add(name);
            }
            result = parsed.toArray(new String[parsed.size()]);
        } else {
            result = new String[]{};
        }
        return result;
    }
}

