/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.select;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.DocumentEvent;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.SelectedObjects;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.event.DocumentListener;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.focus.FocusCommand;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextField;

public class MultiIMObjectSelector<T extends IMObject> {
    private final SelectedObjects<T> objects;
    private final String[] shortNames;
    private final String type;
    private final LayoutContext context;
    private final DocumentListener textListener;
    private final FocusGroup focusGroup;
    private final boolean allowCreate;
    private SelectorListener<T> listener;
    private String prevText;
    private boolean inSelect;
    private TextField field;
    private boolean onTextChangedInvoked;

    public MultiIMObjectSelector(String type, LayoutContext context, String ... shortNames) {
        this(type, new SelectedObjects(), false, context, shortNames);
    }

    public MultiIMObjectSelector(String type, SelectedObjects<T> objects, boolean allowCreate, LayoutContext context, String ... shortNames) {
        this.objects = objects;
        this.type = type;
        this.context = context;
        this.shortNames = shortNames;
        this.allowCreate = allowCreate;
        this.focusGroup = new FocusGroup(this.getClass().getSimpleName());
        TextField text = this.getTextField();
        this.focusGroup.add((Component)text);
        this.textListener = new DocumentListener(){

            public void onUpdate(DocumentEvent event) {
                MultiIMObjectSelector.this.onTextChanged();
            }
        };
        text.getDocument().addDocumentListener((nextapp.echo2.app.event.DocumentListener)this.textListener);
        text.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                MultiIMObjectSelector.this.onTextAction();
            }
        });
    }

    public void setObject(T object) {
        List objects = object == null ? Collections.emptyList() : Collections.singletonList(object);
        this.setObjects(objects);
    }

    public void setObjects(List<T> objects) {
        this.objects.setObjects(objects);
        this.refresh();
        this.prevText = this.field.getText();
    }

    public List<T> getObjects() {
        return this.objects.getObjects();
    }

    public void setListener(SelectorListener<T> listener) {
        this.listener = listener;
    }

    public String getType() {
        return this.type;
    }

    public boolean isValid() {
        this.objects.parseNames(this.getText());
        return !this.inSelect() && this.objects.isValid();
    }

    public boolean inSelect() {
        return this.inSelect;
    }

    public Component getComponent() {
        return this.getTextField();
    }

    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    public TextField getTextField() {
        if (this.field == null) {
            this.field = TextComponentFactory.create();
        }
        return this.field;
    }

    public String getText() {
        return this.getTextField().getText();
    }

    public String getFirstNotFound() {
        return this.objects.getFirstNotFound();
    }

    protected void refresh() {
        this.field.getDocument().removeDocumentListener((nextapp.echo2.app.event.DocumentListener)this.textListener);
        this.field.setText(this.objects.getText());
        String text = this.field.getText();
        if (text != null) {
            this.field.setCursorPosition(this.field.getText().length());
        }
        this.field.getDocument().addDocumentListener((nextapp.echo2.app.event.DocumentListener)this.textListener);
        this.prevText = this.field.getText();
    }

    protected void onSelect() {
        if (!this.inSelect) {
            int index = this.objects.size();
            for (int i = this.objects.size() - 1; i >= 0; --i) {
                if (this.objects.haveMatch(i)) continue;
                index = i;
                break;
            }
            this.onSelect(this.createQuery(null), false, index);
        }
    }

    protected void onSelect(Query<T> query, boolean runQuery, final int index) {
        if (runQuery) {
            query.setAuto(runQuery);
        }
        try {
            final FocusCommand focus = new FocusCommand();
            final Browser<T> browser = this.createBrowser(query, this.context);
            final BrowserDialog<T> popup = this.createBrowserDialog(browser, this.context);
            popup.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    focus.restore();
                    MultiIMObjectSelector.this.setInSelect(false);
                    if (popup.createNew()) {
                        MultiIMObjectSelector.this.onCreate();
                    } else {
                        IMObject object = (IMObject)popup.getSelected();
                        if (object != null) {
                            MultiIMObjectSelector.this.onSelected(object, browser, index);
                        }
                    }
                }
            });
            this.setInSelect(true);
            popup.show();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    protected void onSelected(T object, Browser<T> browser, int index) {
        this.setObject(index, object);
        this.getFocusGroup().setFocus();
        if (this.listener != null) {
            this.listener.selected(object, browser);
        }
    }

    protected void onCreate() {
        if (this.listener != null) {
            this.listener.create();
        }
    }

    protected Query<T> createQuery(String value) {
        Query query = QueryFactory.create(this.shortNames, this.context.getContext());
        query.setValue(value);
        return query;
    }

    protected Browser<T> createBrowser(Query<T> query, LayoutContext context) {
        return BrowserFactory.create(query, context);
    }

    protected BrowserDialog<T> createBrowserDialog(Browser<T> browser, LayoutContext context) {
        return new BrowserDialog<T>(this.type, browser, this.allowCreate, context.getHelpContext());
    }

    protected void setInSelect(boolean select) {
        this.inSelect = select;
    }

    protected boolean query(String text, int index) {
        boolean result = true;
        try {
            Query<T> query = this.createQuery(text);
            ResultSet<T> set = query.query(null);
            if (set != null) {
                IPage page;
                List rows;
                IMObject selected = null;
                if (set.hasNext() && (rows = (page = (IPage)set.next()).getResults()).size() == 1) {
                    selected = (IMObject)rows.get(0);
                }
                if (selected != null) {
                    this.setObject(index, selected);
                    this.notifySelected(selected);
                } else {
                    this.onSelect(query, true, index);
                    result = false;
                }
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
            this.listener.selected(null);
        }
        return result;
    }

    protected void setObject(int index, T object) {
        this.objects.setObject(index, object);
        this.refresh();
    }

    private void onTextChanged() {
        this.onTextChangedInvoked = true;
        String text = this.getText();
        if (!Objects.equals(text, this.prevText)) {
            if (StringUtils.isEmpty((CharSequence)text)) {
                this.clear();
            } else {
                this.objects.parseNames(this.getText());
                List<String> names = this.objects.getNames();
                for (int i = 0; i < names.size(); ++i) {
                    String name = names.get(i);
                    if (this.objects.haveMatch(i) || this.query(name, i)) continue;
                    return;
                }
            }
        }
    }

    private void clear() {
        this.objects.clear();
        this.prevText = null;
        this.notifySelected(null);
    }

    private void onTextAction() {
        if (!this.onTextChangedInvoked) {
            this.onSelect();
        } else {
            this.onTextChangedInvoked = false;
        }
    }

    private void notifySelected(T object) {
        if (this.listener != null) {
            this.listener.selected(object);
        }
    }
}

