/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.web.system.ServiceHelper;

public class RelationshipState {
    private final Relationship relationship;
    private long sourceId;
    private String sourceName;
    private String sourceDescription;
    private long targetId;
    private String targetName;
    private String targetDescription;
    private boolean active;
    private IMObjectBean bean;

    public RelationshipState(Relationship relationship, long sourceId, String sourceName, String sourceDescription, long targetId, String targetName, String targetDescription, boolean active) {
        this.relationship = relationship;
        this.sourceId = sourceId;
        this.sourceName = sourceName;
        this.sourceDescription = sourceDescription;
        this.targetId = targetId;
        this.targetName = targetName;
        this.targetDescription = targetDescription;
        this.active = active;
    }

    public RelationshipState(IMObject parent, Relationship relationship, boolean source) {
        Reference reference;
        this.relationship = relationship;
        Reference reference2 = reference = source ? relationship.getTarget() : relationship.getSource();
        if (reference != null) {
            ObjectRefConstraint constraint = new ObjectRefConstraint("o", reference);
            ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)constraint);
            query.add((IConstraint)new NodeSelectConstraint("o.id"));
            query.add((IConstraint)new NodeSelectConstraint("o.name"));
            query.add((IConstraint)new NodeSelectConstraint("o.description"));
            query.add((IConstraint)new NodeSelectConstraint("o.active"));
            query.setMaxResults(1);
            ObjectSetQueryIterator iter = new ObjectSetQueryIterator((IArchetypeQuery)query);
            if (iter.hasNext()) {
                ObjectSet set = (ObjectSet)iter.next();
                long id = set.getLong("o.id");
                String name = set.getString("o.name");
                String desc = set.getString("o.description");
                this.active = set.getBoolean("o.active");
                if (source) {
                    this.sourceId = parent.getId();
                    this.sourceName = parent.getName();
                    this.sourceDescription = parent.getDescription();
                    this.targetId = id;
                    this.targetName = name;
                    this.targetDescription = desc;
                } else {
                    this.sourceId = id;
                    this.sourceName = name;
                    this.sourceDescription = desc;
                    this.targetId = parent.getId();
                    this.targetName = parent.getName();
                    this.targetDescription = parent.getDescription();
                }
            }
        } else {
            this.active = true;
        }
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getTargetDescription() {
        return this.targetDescription;
    }

    public boolean isActive() {
        return this.active && this.relationship.isActive();
    }

    public Reference getSource() {
        return this.relationship.getSource();
    }

    public Reference getTarget() {
        return this.relationship.getTarget();
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public IMObjectBean getBean() {
        if (this.bean == null) {
            this.bean = ServiceHelper.getArchetypeService().getBean((IMObject)this.relationship);
        }
        return this.bean;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof RelationshipState && ((RelationshipState)obj).relationship.equals(this.relationship);
    }

    public int hashCode() {
        return this.relationship.hashCode();
    }

    public boolean updated() {
        long relSource = this.relationship.getSource() != null ? this.relationship.getSource().getId() : 0L;
        long relTarget = this.relationship.getTarget() != null ? this.relationship.getTarget().getId() : 0L;
        return this.sourceId != relSource || this.targetId != relTarget;
    }
}

