/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.im.edit.AbstractCollectionPropertyEditor;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.RelationshipStateFactory;
import org.openvpms.web.component.im.relationship.RelationshipStateQuery;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.system.ServiceHelper;

public abstract class RelationshipCollectionPropertyEditor
extends AbstractCollectionPropertyEditor {
    private final IMObject parent;
    private final boolean parentIsSource;
    private final RelationshipStateFactory factory;
    private final Map<Relationship, RelationshipState> states;
    private final Set<Relationship> added = new HashSet<Relationship>();
    private final Set<Relationship> removed = new HashSet<Relationship>();
    private boolean exclude = true;

    public RelationshipCollectionPropertyEditor(CollectionProperty property, IMObject parent) {
        super(property);
        this.parent = parent;
        RelationshipStateQuery query = this.createQuery(parent);
        this.parentIsSource = query.parentIsSource();
        this.factory = query.getFactory();
        this.states = query.query();
    }

    public IMObject getParent() {
        return this.parent;
    }

    public void setExcludeInactive(boolean exclude) {
        this.exclude = exclude;
    }

    public boolean getExcludeInactive() {
        return this.exclude;
    }

    public boolean parentIsSource() {
        return this.parentIsSource;
    }

    public Collection<RelationshipState> getRelationships() {
        ArrayList<RelationshipState> result;
        if (this.exclude) {
            result = new ArrayList();
            for (RelationshipState relationship : this.states.values()) {
                if (!relationship.isActive()) continue;
                result.add(relationship);
            }
        } else {
            result = this.states.values();
        }
        return result;
    }

    public RelationshipState getRelationshipState(Relationship relationship) {
        return this.states.get(relationship);
    }

    @Override
    public boolean add(IMObject object) {
        boolean result = super.add(object);
        Relationship relationship = (Relationship)object;
        if (result) {
            this.updateRelationshipState(relationship);
            this.added.add(relationship);
        } else {
            RelationshipState state = this.states.get(relationship);
            if (state != null && state.updated()) {
                this.updateRelationshipState(relationship);
            }
        }
        return result;
    }

    @Override
    public boolean remove(IMObject object) {
        Relationship relationship = (Relationship)object;
        this.states.remove(relationship);
        if (!relationship.isNew()) {
            this.removed.add(relationship);
        } else {
            this.added.remove(relationship);
        }
        return super.remove((IMObject)relationship);
    }

    protected RelationshipStateQuery createQuery(IMObject parent) {
        return new RelationshipStateQuery(parent, this.getObjects(), this.getProperty().getArchetypeRange());
    }

    @Override
    protected void addEdited(IMObject object) {
    }

    @Override
    protected void doSave() {
        HashMap<Reference, IMObject> toSave = new HashMap<Reference, IMObject>();
        this.removeRelationships(this.removed, toSave);
        this.addRelationships(this.added, toSave);
        if (!toSave.isEmpty()) {
            ServiceHelper.getArchetypeService().save(toSave.values());
            this.removed.clear();
            this.added.clear();
        }
        this.setSaved(true);
    }

    protected void addRelationships(Set<Relationship> added, Map<Reference, IMObject> changed) {
        for (Relationship r : added) {
            IMObject object = this.getObject(r, changed);
            if (object == null) continue;
            this.addRelationship(object, r);
        }
    }

    protected void removeRelationships(Set<Relationship> removed, Map<Reference, IMObject> changed) {
        for (Relationship r : removed) {
            IMObject object = this.getObject(r, changed);
            if (object == null) continue;
            this.removeRelationship(object, r);
        }
    }

    protected abstract void addRelationship(IMObject var1, Relationship var2);

    protected abstract void removeRelationship(IMObject var1, Relationship var2);

    private void updateRelationshipState(Relationship relationship) {
        RelationshipState state = this.factory.create(this.getParent(), relationship, this.parentIsSource);
        this.states.put(relationship, state);
    }

    private IMObject getObject(Relationship relationship, Map<Reference, IMObject> cache) {
        Reference ref;
        IMObject object = null;
        Reference reference = ref = this.parentIsSource() ? relationship.getTarget() : relationship.getSource();
        if (ref != null && (object = cache.get(ref)) == null && (object = ServiceHelper.getArchetypeService().get(ref)) != null) {
            cache.put(ref, object);
        }
        return object;
    }
}

