/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractCollectionPropertyEditor;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractRemovableCollectionPropertyEditor
extends AbstractCollectionPropertyEditor {
    private final Set<IMObject> removed = new HashSet<IMObject>();
    private final Map<IMObject, IMObjectEditor> removedEditors = new HashMap<IMObject, IMObjectEditor>();
    private final IArchetypeService service = ServiceHelper.getArchetypeService();

    public AbstractRemovableCollectionPropertyEditor(CollectionProperty property) {
        super(property);
    }

    @Override
    protected void doSave() {
        if (!this.removed.isEmpty()) {
            this.remove();
        }
        super.doSave();
    }

    @Override
    protected void remove(IMObject object, IMObjectEditor editor) {
        this.queueRemove(object, editor);
        super.remove(object, editor);
    }

    protected void queueRemove(IMObject object, IMObjectEditor editor) {
        this.removed.add(object);
        if (editor != null) {
            this.removedEditors.put(object, editor);
        }
    }

    protected void remove() {
        IMObject[] toRemove = this.removed.toArray(new IMObject[0]);
        CollectionPropertyEditor.RemoveHandler handler = this.getRemoveHandler();
        for (IMObject object : toRemove) {
            IMObjectEditor editor = this.removedEditors.get(object);
            if (editor != null) {
                if (handler != null) {
                    handler.remove(editor);
                } else {
                    editor.delete();
                }
            } else if (handler != null) {
                handler.remove(object);
            } else {
                this.service.remove(object);
            }
            this.removed.remove(object);
            this.removedEditors.remove(object);
        }
    }

    protected IArchetypeService getService() {
        return this.service;
    }
}

