/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditorFactory;
import org.openvpms.web.component.im.filter.NodeFilter;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;

public abstract class AbstractRelationshipEditor<T extends IMObject>
extends AbstractIMObjectEditor {
    private final ArchetypeNodes nodes;
    private IMObjectReferenceEditor<T> sourceEditor;
    private IMObjectReferenceEditor<T> targetEditor;
    private static final String SOURCE = "source";
    private static final String TARGET = "target";

    public AbstractRelationshipEditor(IMObject relationship, IMObject parent, LayoutContext layoutContext) {
        super(relationship, parent, layoutContext);
        IMObjectCache cache = layoutContext.getCache();
        Property sourceProp = this.getSource();
        Property targetProp = this.getTarget();
        Reference sourceRef = sourceProp.getReference();
        Reference targetRef = targetProp.getReference();
        IMObject source = this.getObject(sourceRef, parent, sourceProp.getArchetypeRange(), cache);
        IMObject target = this.getObject(targetRef, parent, targetProp.getArchetypeRange(), cache);
        if (sourceRef == null && source != null) {
            sourceProp.setValue(source.getObjectReference());
        }
        if (targetRef == null && target != null && !Objects.equals(source, target)) {
            targetProp.setValue(target.getObjectReference());
        }
        this.nodes = new ArchetypeNodes();
        if (source == null || !source.equals(parent)) {
            this.sourceEditor = this.createSourceEditor(sourceProp, layoutContext);
            this.addEditor(this.sourceEditor);
            this.nodes.simple(SOURCE);
            this.nodes.first(SOURCE);
            this.nodes.exclude(TARGET);
        }
        if (target == null || !target.equals(parent) || target.equals(source)) {
            this.targetEditor = this.createTargetEditor(targetProp, layoutContext);
            this.addEditor(this.targetEditor);
            this.nodes.simple(TARGET);
            this.nodes.first(TARGET);
            this.nodes.exclude(SOURCE);
        }
    }

    public void setSource(T source) {
        if (this.sourceEditor != null) {
            this.sourceEditor.setObject(source);
        } else {
            this.getSource().setValue(source != null ? source.getObjectReference() : null);
        }
    }

    public Reference getSourceRef() {
        return this.getSource().getReference();
    }

    public void setTarget(T target) {
        if (this.targetEditor != null) {
            this.targetEditor.setObject(target);
        } else {
            this.getTarget().setValue(target != null ? target.getObjectReference() : null);
        }
    }

    public Reference getTargetRef() {
        return this.getTarget().getReference();
    }

    public boolean isEmpty() {
        boolean result = false;
        ArrayList<Property> editable = new ArrayList<Property>(this.getProperties().getEditable());
        editable.remove(this.getSource());
        editable.remove(this.getTarget());
        if (editable.isEmpty()) {
            if (this.getSourceEditor() != null) {
                result = this.getSource().getValue() == null;
            } else if (this.getTargetEditor() != null) {
                result = this.getTarget().getValue() == null;
            }
        }
        return result;
    }

    protected Property getSource() {
        return this.getProperty(SOURCE);
    }

    protected Property getTarget() {
        return this.getProperty(TARGET);
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    protected IMObjectReferenceEditor<T> getSourceEditor() {
        return this.sourceEditor;
    }

    protected IMObjectReferenceEditor<T> getTargetEditor() {
        return this.targetEditor;
    }

    protected IMObjectReferenceEditor<T> createSourceEditor(Property property, LayoutContext context) {
        return this.createReferenceEditor(property, context);
    }

    protected IMObjectReferenceEditor<T> createTargetEditor(Property property, LayoutContext context) {
        return this.createReferenceEditor(property, context);
    }

    protected IMObjectReferenceEditor<T> createReferenceEditor(Property property, LayoutContext context) {
        IMObjectReferenceEditor editor = IMObjectReferenceEditorFactory.create(property, this.getObject(), context);
        editor.setAllowCreate(true);
        return editor;
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return this.nodes;
    }

    private IMObject getObject(Reference reference, IMObject parent, String[] archetypeRange, IMObjectCache cache) {
        IMObject result = null;
        if (reference == null) {
            if (TypeHelper.isA((IMObject)parent, (String[])archetypeRange)) {
                result = parent;
            }
        } else {
            result = reference.equals((Object)parent.getObjectReference()) ? parent : cache.get(reference);
        }
        return result;
    }

    protected class LayoutStrategy
    extends AbstractLayoutStrategy {
        public LayoutStrategy() {
            super(AbstractRelationshipEditor.this.nodes);
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            if (AbstractRelationshipEditor.this.sourceEditor != null) {
                this.addComponent(new ComponentState(AbstractRelationshipEditor.this.sourceEditor));
            }
            if (AbstractRelationshipEditor.this.targetEditor != null) {
                this.addComponent(new ComponentState(AbstractRelationshipEditor.this.targetEditor));
            }
            return super.apply(object, properties, parent, context);
        }

        @Override
        protected void doLayout(IMObject object, PropertySet properties, IMObject parent, Component container, LayoutContext context) {
            ArchetypeDescriptor archetype = context.getArchetypeDescriptor(object);
            ArchetypeNodes nodes = this.getArchetypeNodes();
            NodeFilter filter = this.getNodeFilter(object, context);
            List<Property> simple = nodes.getSimpleNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
            List<Property> complex = nodes.getComplexNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
            if (simple.size() == 1 && complex.isEmpty()) {
                ComponentSet set = this.createComponentSet(object, simple, context);
                ComponentState state = set.getComponents().get(0);
                this.setFocusTraversal(state);
                container.add(state.getComponent());
            } else {
                this.doSimpleLayout(object, parent, simple, container, context);
                this.doComplexLayout(object, parent, complex, container, context);
            }
        }
    }
}

