/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.Path;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.RelationalOp;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.web.component.im.query.PageLocator;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.system.ServiceHelper;

public class QueryHelper {
    public static boolean isParticipationNode(NodeDescriptor descriptor) {
        return descriptor.isCollection() && "/participations".equals(descriptor.getPath());
    }

    public static NodeDescriptor getDescriptor(ShortNameConstraint archetypes, String node) {
        ArchetypeDescriptor archetype;
        String[] shortNames = archetypes.getShortNames();
        if (shortNames.length > 0 && (archetype = ServiceHelper.getArchetypeService().getArchetypeDescriptor(shortNames[0])) != null) {
            return archetype.getNodeDescriptor(node);
        }
        return null;
    }

    public static void addSortOnParticipation(ShortNameConstraint acts, ArchetypeQuery query, NodeDescriptor descriptor, boolean ascending) {
        JoinConstraint particJoin = Constraints.leftJoin((String)descriptor.getName(), (String)QueryHelper.getAlias(descriptor.getName(), query));
        JoinConstraint entityJoin = Constraints.leftJoin((String)"entity", (String)QueryHelper.getAlias("entity", query));
        particJoin.add((IConstraint)entityJoin);
        acts.add((IConstraint)particJoin);
        query.add((IConstraint)Constraints.sort((String)entityJoin.getAlias(), (String)"name", (boolean)ascending));
    }

    public static <T extends IMObject> boolean selects(ResultSet<T> set, Reference reference) {
        boolean result = false;
        ResultSetIterator<T> iter = new ResultSetIterator<T>(set);
        while (iter.hasNext()) {
            if (!((IMObject)iter.next()).getObjectReference().equals((Object)reference)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static <T extends IMObject> List<T> query(ArchetypeQuery query) {
        return QueryHelper.query(query, (IArchetypeService)ServiceHelper.getArchetypeService());
    }

    public static <T extends IMObject> List<T> query(ArchetypeQuery query, IArchetypeService service) {
        ArrayList matches = new ArrayList();
        CollectionUtils.addAll(matches, (Iterator)new IMObjectQueryIterator(service, (IArchetypeQuery)query));
        return matches;
    }

    public static <T extends IMObject> List<T> query(Query<T> query) {
        ArrayList matches = new ArrayList();
        ResultSet<T> set = query.query();
        if (set != null) {
            CollectionUtils.addAll(matches, new ResultSetIterator<T>(set));
        }
        return matches;
    }

    public static <T extends IMObject> List<T> query(String[] shortNames, String ... sortNodes) {
        ArchetypeQuery query = new ArchetypeQuery(shortNames, false, true);
        for (String sort : sortNodes) {
            query.add((IConstraint)Constraints.sort((String)sort));
        }
        return QueryHelper.query(query);
    }

    public static IConstraint createDateRangeConstraint(Date date) {
        return QueryHelper.createDateRangeConstraint(date, "startTime", "endTime");
    }

    public static IConstraint createDateRangeConstraint(Date date, String from, String to) {
        return Constraints.and((IConstraint[])new IConstraint[]{Constraints.lte((String)from, (Object)date), Constraints.or((IConstraint[])new IConstraint[]{Constraints.gte((String)to, (Object)date), Constraints.isNull((String)to)})});
    }

    public static Predicate createDateRangePredicate(Date date, Path<Date> from, Path<Date> to, CriteriaBuilder builder) {
        return builder.and((Expression)builder.lessThanOrEqualTo(from, (Comparable)date), (Expression)builder.or((Expression)builder.greaterThanOrEqualTo(to, (Comparable)date), (Expression)builder.isNull(to)));
    }

    public static IConstraint createDateRangeConstraint(Date from, Date to) {
        OrConstraint result = to != null ? Constraints.or((IConstraint[])new IConstraint[]{QueryHelper.createDateRangeConstraint(from), QueryHelper.createDateRangeConstraint(to)}) : Constraints.or((IConstraint[])new IConstraint[]{Constraints.gte((String)"startTime", (Object)from), QueryHelper.createDateRangeConstraint(from)});
        return result;
    }

    public static IConstraint createParticipationDateRangeConstraint(Date from, Date to) {
        OrConstraint result;
        if (to != null) {
            result = Constraints.or((IConstraint[])new IConstraint[]{QueryHelper.createParticipationDateRangeConstraint(from), QueryHelper.createParticipationDateRangeConstraint(to)});
        } else {
            ParticipationConstraint gte = new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.GTE, (Object)from);
            result = Constraints.or((IConstraint[])new IConstraint[]{gte, QueryHelper.createParticipationDateRangeConstraint(from)});
        }
        return result;
    }

    public static IConstraint createParticipationDateRangeConstraint(Date date) {
        ParticipationConstraint lte = new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.LTE, (Object)date);
        ParticipationConstraint gte = new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.GTE, (Object)date);
        ParticipationConstraint isNull = new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.IS_NULL);
        return Constraints.and((IConstraint[])new IConstraint[]{lte, Constraints.or((IConstraint[])new IConstraint[]{gte, isNull})});
    }

    public static IConstraint createDateConstraint(String node, Date from, Date to) {
        NodeConstraint result;
        if (from == null && to == null) {
            result = null;
        } else if (from != null && to == null) {
            from = DateRules.getDate((Date)from);
            result = Constraints.gte((String)node, (Object)from);
        } else if (from == null) {
            to = DateRules.getNextDate((Date)to);
            result = Constraints.lt((String)node, (Object)to);
        } else {
            from = DateRules.getDate((Date)from);
            to = DateRules.getNextDate((Date)to);
            result = Constraints.and((IConstraint[])new IConstraint[]{Constraints.gte((String)node, (Object)from), Constraints.lt((String)node, (Object)to)});
        }
        return result;
    }

    public static boolean isEntityLinkNode(NodeDescriptor descriptor) {
        return descriptor.isCollection() && "/entityLinks".equals(descriptor.getPath());
    }

    public static void addSortOnEntityLink(ShortNameConstraint acts, ArchetypeQuery query, NodeDescriptor descriptor, boolean ascending) {
        JoinConstraint linkJoin = Constraints.leftJoin((String)descriptor.getName(), (String)QueryHelper.getAlias(descriptor.getName(), query));
        JoinConstraint targetJoin = Constraints.leftJoin((String)"target", (String)QueryHelper.getAlias("target", query));
        linkJoin.add((IConstraint)targetJoin);
        acts.add((IConstraint)linkJoin);
        query.add((IConstraint)Constraints.sort((String)targetJoin.getAlias(), (String)"name", (boolean)ascending));
    }

    public static <T extends Comparable> int getPage(IMObject object, ArchetypeQuery query, int pageSize, String node, boolean ascending, Comparator<T> comparator) {
        PageLocator locator = new PageLocator(object, query, pageSize);
        locator.addKey(node, ascending, comparator);
        return locator.getPage();
    }

    public static void addParticipantConstraint(List<ParticipantConstraint> constraints, String name, String shortName, Entity object) {
        if (object != null) {
            constraints.add(new ParticipantConstraint(name, shortName, object));
        }
    }

    public static Pattern getWildcardPattern(String expression) {
        StringBuilder builder = new StringBuilder(expression.length());
        int length = expression.length();
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if ("[](){}.+?$^|#\\".indexOf(c) != -1) {
                builder.append("\\");
            }
            builder.append(c);
        }
        String regex = builder.toString();
        regex = regex.replace("*", ".*?");
        return Pattern.compile(regex, 2);
    }

    public static Participation getParticipation(Entity entity, String shortName) {
        ArchetypeQuery query = new ArchetypeQuery(shortName, true, true);
        query.add((IConstraint)Constraints.eq((String)"entity", (Object)entity));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setFirstResult(0);
        query.setMaxResults(1);
        List rows = QueryHelper.query(query);
        return !rows.isEmpty() ? (Participation)rows.get(0) : null;
    }

    public static Long[] getIds(List<Reference> references) {
        Object[] result = new Long[references.size()];
        for (int i = 0; i < references.size(); ++i) {
            result[i] = references.get(i).getId();
        }
        Arrays.sort(result);
        return result;
    }

    private static String getAlias(String prefix, ArchetypeQuery query) {
        return prefix + QueryHelper.getAliasSuffix(prefix, (IConstraint)query.getArchetypeConstraint(), 0);
    }

    private static int getAliasSuffix(String prefix, IConstraint constraint, int maxId) {
        BaseArchetypeConstraint arch;
        String alias;
        if (constraint instanceof BaseArchetypeConstraint && (alias = (arch = (BaseArchetypeConstraint)constraint).getAlias()) != null && alias.startsWith(prefix)) {
            String suffix = alias.substring(prefix.length());
            try {
                int id = Integer.parseInt(suffix);
                if (id > maxId) {
                    maxId = id + 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (IConstraint child : arch.getConstraints()) {
                maxId = QueryHelper.getAliasSuffix(prefix, child, maxId);
            }
        }
        return maxId;
    }
}

