/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.NonRenderingQuery;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectSorter;

public class ListQuery<T>
extends NonRenderingQuery<T> {
    private final List<T> objects;

    public ListQuery(List<T> objects, String shortName, Class<T> type) {
        this(objects, shortName, true, type);
    }

    public ListQuery(List<T> objects, String shortName, boolean primaryOnly, Class<T> type) {
        this(objects, new String[]{shortName}, primaryOnly, type);
    }

    public ListQuery(List<T> objects, String[] shortNames, Class<T> type) {
        this(objects, shortNames, false, type);
    }

    public ListQuery(List<T> objects, String[] shortNames, boolean primaryOnly, Class<T> type) {
        super(shortNames, primaryOnly, (Class)type);
        this.objects = objects;
        this.setAuto(true);
    }

    @Override
    public ResultSet<T> query(SortConstraint[] sort) {
        if (sort != null && IMObject.class.isAssignableFrom(this.getType())) {
            ArrayList<T> sorted = new ArrayList<T>(this.objects);
            IMObjectSorter.sort(sorted, sort);
            return new ListResultSet<T>(sorted, this.getMaxResults());
        }
        return new ListResultSet<T>(this.objects, this.getMaxResults());
    }

    @Override
    public boolean selects(Reference reference) {
        if (IMObject.class.isAssignableFrom(this.getType())) {
            for (T object : this.objects) {
                IMObject o = (IMObject)object;
                if (!o.getObjectReference().equals((Object)reference)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public BaseArchetypeConstraint.State getActive() {
        return BaseArchetypeConstraint.State.BOTH;
    }
}

