/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.component.system.common.util.StringUtilities;
import org.openvpms.web.component.im.query.AbstractArchetypeQuery;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectSorter;

public class InMemoryQuery<T extends IMObject>
extends AbstractArchetypeQuery<T> {
    private final List<T> objects;

    public InMemoryQuery(String archetype, Class<T> type, List<T> objects) {
        this(new String[]{archetype}, type, objects);
    }

    public InMemoryQuery(String[] archetypes, Class<T> type, List<T> objects) {
        super(archetypes, (Class)type);
        this.objects = objects;
    }

    @Override
    public String getValue() {
        return StringUtils.trimToNull((String)this.getSearchField().getText());
    }

    @Override
    protected ResultSet<T> createResultSet(SortConstraint[] sort) {
        List list = this.objects.stream().filter(this::matches).collect(Collectors.toList());
        SortableListResultSet set = new SortableListResultSet(list, this.getMaxResults());
        set.sort(sort);
        return set;
    }

    protected boolean matches(T object) {
        BaseArchetypeConstraint.State state;
        boolean result = false;
        if (object.isA(this.getArchetypes().getShortNames()) && (result = (state = this.getActive()) == BaseArchetypeConstraint.State.ACTIVE ? object.isActive() : (state == BaseArchetypeConstraint.State.INACTIVE ? !object.isActive() : true))) {
            result = this.matches(object, StringUtils.trimToNull((String)this.getValue()));
        }
        return result;
    }

    protected boolean matches(T object, String value) {
        return value == null || this.startsWith(object.getName(), value);
    }

    protected boolean contains(String field, String value) {
        boolean result = false;
        if (field != null) {
            field = field.toLowerCase();
            result = (value = value.toLowerCase()).contains("*") ? StringUtilities.matches((String)field, (String)value) : field.contains(value);
        }
        return result;
    }

    protected boolean startsWith(String field, String value) {
        boolean result = false;
        if (field != null) {
            field = field.toLowerCase();
            result = (value = value.toLowerCase()).contains("*") ? StringUtilities.matches((String)field, (String)value) : field.startsWith(value);
        }
        return result;
    }

    private static class SortableListResultSet<T extends IMObject>
    extends ListResultSet<T> {
        public SortableListResultSet(List<T> objects, int pageSize) {
            super(objects, pageSize);
        }

        @Override
        public void sort(SortConstraint[] sort) {
            if (sort != null) {
                IMObjectSorter.sort(this.getObjects(), sort);
            }
            super.sort(sort);
        }
    }
}

