/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.query.MultiSelectTableBrowser;

public class IMObjectSelections<T extends IMObject>
implements MultiSelectTableBrowser.SelectionTracker<T> {
    private final Map<Reference, T> objects = new LinkedHashMap<Reference, T>();
    private Runnable listener;

    @Override
    public boolean isSelected(T object) {
        return this.objects.containsKey(object.getObjectReference());
    }

    @Override
    public void setSelected(T object, boolean selected) {
        Reference ref = object.getObjectReference();
        boolean changed = false;
        if (selected) {
            if (this.objects.put(ref, object) == null) {
                changed = true;
            }
        } else if (this.objects.remove(ref) != null) {
            changed = true;
        }
        if (changed && this.listener != null) {
            this.listener.run();
        }
    }

    @Override
    public Collection<T> getSelected() {
        return this.objects.values();
    }

    @Override
    public boolean canSelect(T object) {
        return true;
    }

    @Override
    public void clear() {
        this.objects.clear();
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public void setListener(Runnable listener) {
        this.listener = listener;
    }
}

