/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.dao.im.Page;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;

public abstract class FilteredResultSet<T>
extends AbstractResultSet<T> {
    private final ResultSet<T> set;
    private ResultSetIterator<T> iterator;
    private List<IPage<T>> pages = new ArrayList<IPage<T>>();

    public FilteredResultSet(ResultSet<T> set) {
        super(set.getPageSize());
        this.set = set;
    }

    @Override
    public void reset() {
        this.set.reset();
        this.initPages();
        super.reset();
    }

    @Override
    public void sort(SortConstraint[] sort) {
        this.set.sort(sort);
        super.reset();
        this.initPages();
    }

    @Override
    public int getResults() {
        return this.count();
    }

    @Override
    public int getEstimatedResults() {
        IPage<T> page = this.getLast();
        return page != null ? page.getFirstResult() + page.getResults().size() : 0;
    }

    @Override
    public boolean isEstimatedActual() {
        return this.iterator != null && !this.iterator.hasNext();
    }

    @Override
    public boolean isSortedAscending() {
        return this.set.isSortedAscending();
    }

    @Override
    public SortConstraint[] getSortConstraints() {
        return this.set.getSortConstraints();
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.set.setDistinct(distinct);
    }

    @Override
    public boolean isDistinct() {
        return this.set.isDistinct();
    }

    protected abstract void filter(T var1, List<T> var2);

    @Override
    protected IPage<T> get(int page) {
        this.fill(page);
        return this.pages.size() > page ? this.pages.get(page) : null;
    }

    private void fill(int page) {
        if (this.iterator == null) {
            this.iterator = new ResultSetIterator<T>(this.set);
        }
        int pageSize = this.getPageSize();
        while ((page == -1 || pageSize == -1 || page >= this.pages.size() || this.pages.get(page).getResults().size() < pageSize) && this.iterator.hasNext()) {
            ArrayList objects = new ArrayList();
            while (this.iterator.hasNext() && (pageSize == -1 || objects.size() < pageSize)) {
                T object = this.iterator.next();
                this.filter(object, objects);
            }
            if (objects.isEmpty()) continue;
            this.addPages(objects);
        }
    }

    private void addPages(List<T> objects) {
        int pageSize = this.getPageSize();
        int index = 0;
        IPage<T> last = this.getLast();
        if (last != null && (pageSize == -1 || last.getResults().size() < pageSize)) {
            int end = pageSize - last.getResults().size();
            if (end > objects.size()) {
                end = objects.size();
            }
            last.getResults().addAll(objects.subList(0, end));
            index = end;
        }
        int first = this.pages.size() * pageSize;
        while (index < objects.size()) {
            int end = pageSize == -1 || index + pageSize > objects.size() ? objects.size() : index + pageSize;
            if (index >= end) continue;
            ArrayList<T> list = new ArrayList<T>(objects.subList(index, end));
            Page page = new Page(list, first, pageSize, -1);
            this.pages.add((IPage<T>)page);
            first += pageSize;
            index = end;
        }
    }

    private void initPages() {
        this.iterator = null;
        this.pages.clear();
    }

    private int count() {
        int result = 0;
        this.fill(-1);
        IPage<T> page = this.getLast();
        if (page != null) {
            result = page.getFirstResult() + page.getResults().size();
        }
        return result;
    }

    private IPage<T> getLast() {
        return !this.pages.isEmpty() ? this.pages.get(this.pages.size() - 1) : null;
    }
}

