/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.DefaultIMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryException;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrowserFactory {
    private static ArchetypeHandlers<Browser> browsers;
    private static final Logger log;

    private BrowserFactory() {
    }

    public static <T> Browser<T> create(Query<T> query, LayoutContext context) {
        return BrowserFactory.create(query, null, context);
    }

    public static <T> Browser<T> create(Query<T> query, SortConstraint[] sort, LayoutContext context) {
        Browser<T> result = null;
        String[] shortNames = DescriptorHelper.getShortNames((String[])query.getShortNames(), (ArchetypeService)ServiceHelper.getArchetypeService());
        ArchetypeHandler handler = BrowserFactory.getBrowsers().getHandler(shortNames);
        if (handler != null) {
            result = BrowserFactory.create((ArchetypeHandler<Browser>)handler, query, sort, context);
        }
        if (result == null) {
            result = BrowserFactory.createDefaultBrowser(query, sort, null, shortNames, context);
        }
        return result;
    }

    public static <T> Browser<T> create(Query<T> query, SortConstraint[] sort, IMTableModel<T> model, LayoutContext context) {
        Browser<T> result = null;
        String[] shortNames = DescriptorHelper.getShortNames((String[])query.getShortNames(), (ArchetypeService)ServiceHelper.getArchetypeService());
        ArchetypeHandler handler = BrowserFactory.getBrowsers().getHandler(shortNames);
        if (handler != null) {
            result = BrowserFactory.create((ArchetypeHandler<Browser>)handler, query, sort, model, context);
        }
        if (result == null) {
            result = BrowserFactory.createDefaultBrowser(query, sort, model, shortNames, context);
        }
        return result;
    }

    private static <T> Browser<T> createDefaultBrowser(Query<T> query, SortConstraint[] sort, IMTableModel<T> model, String[] shortNames, LayoutContext context) {
        DefaultIMObjectTableBrowser<T> result;
        Class<?> type = query.getType();
        if (IMObject.class.isAssignableFrom(type)) {
            result = model != null ? new DefaultIMObjectTableBrowser<T>(query, sort, model, context) : new DefaultIMObjectTableBrowser<T>(query, sort, context);
        } else {
            throw new QueryException(QueryException.ErrorCode.NoBrowser, StringUtils.join((Object[])shortNames, (String)", "), type.getName());
        }
        return result;
    }

    private static <T> Browser<T> create(ArchetypeHandler<Browser> handler, Query<T> query, LayoutContext context) {
        Browser result = null;
        try {
            Object[] args = new Object[]{query, context};
            Class[] types = new Class[]{query.getClass(), LayoutContext.class};
            result = (Browser)handler.create(args, types);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
        }
        return result;
    }

    private static <T> Browser<T> create(ArchetypeHandler<Browser> handler, Query<T> query, SortConstraint[] sort, LayoutContext context) {
        Browser result = null;
        try {
            Object[] args = new Object[]{query, sort, context};
            Class[] types = new Class[]{query.getClass(), SortConstraint[].class, LayoutContext.class};
            result = (Browser)handler.create(args, types);
        }
        catch (NoSuchMethodException ignore) {
            result = BrowserFactory.create(handler, query, context);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
        }
        return result;
    }

    private static <T> Browser<T> create(ArchetypeHandler<Browser> handler, Query<T> query, SortConstraint[] sort, IMTableModel<T> model, LayoutContext context) {
        Browser result = null;
        try {
            Object[] args = new Object[]{query, sort, model, context};
            Class[] types = new Class[]{Query.class, SortConstraint[].class, IMTableModel.class, LayoutContext.class};
            result = (Browser)handler.create(args, types);
        }
        catch (NoSuchMethodException ignore) {
            result = BrowserFactory.create(handler, query, sort, context);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
        }
        return result;
    }

    private static synchronized ArchetypeHandlers<Browser> getBrowsers() {
        if (browsers == null) {
            browsers = new ArchetypeHandlers("BrowserFactory.properties", Browser.class, (ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        }
        return browsers;
    }

    static {
        log = LoggerFactory.getLogger(BrowserFactory.class);
    }
}

