/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.PaneContainer;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.BrowserStates;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.util.StyleSheetHelper;

public class BrowserDialog<T>
extends PopupDialog {
    public static final String NEW_ID = "new";
    private T selected;
    private boolean createNew = false;
    private Browser<T> browser;
    private boolean closeOnSelection = true;
    private static final String STYLE = "BrowserDialog";

    public BrowserDialog(String title, Browser<T> browser, HelpContext help) {
        this(title, browser, false, help);
    }

    public BrowserDialog(String title, String[] buttons, Browser<T> browser, HelpContext help) {
        this(title, null, buttons, browser, false, help);
    }

    public BrowserDialog(String title, Browser<T> browser, boolean addNew, HelpContext help) {
        this(title, null, CANCEL, browser, addNew, help);
    }

    public BrowserDialog(String title, String message, String[] buttons, Browser<T> browser, boolean addNew, HelpContext help) {
        this(title, buttons, addNew, help);
        this.init(browser, message);
    }

    protected BrowserDialog(String title, String[] buttons, boolean addNew, HelpContext help) {
        super(title, STYLE, buttons, help);
        this.setModal(true);
        if (addNew) {
            this.addButton(NEW_ID, this::onNew);
        }
    }

    public void setCloseOnSelection(boolean close) {
        this.closeOnSelection = close;
    }

    public Browser<T> getBrowser() {
        return this.browser;
    }

    public T getSelected() {
        return this.selected;
    }

    public boolean isSelected() {
        return this.getSelected() != null;
    }

    public boolean createNew() {
        return this.createNew;
    }

    public void close(String action) {
        if ("cancel".equals(action)) {
            this.setSelected(null);
        } else {
            BrowserStates.getInstance().add(this.browser);
        }
        super.close(action);
    }

    protected void init(Browser<T> browser, String message) {
        Component component = browser.getComponent();
        if (message != null) {
            Label label = LabelFactory.create(null, (String)"bold");
            label.setText(message);
            Row inset = RowFactory.create((String)"Inset", (Component[])new Component[]{label});
            if (component instanceof PaneContainer) {
                SplitPane pane = SplitPaneFactory.create((int)5);
                int size = StyleSheetHelper.getProperty((String)"font.size", (int)-1);
                if (size != -1) {
                    pane.setSeparatorPosition(new Extent(size * 2));
                }
                pane.add((Component)inset);
                pane.add(component);
                component = pane;
            } else {
                component = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{inset, component});
            }
        }
        this.getLayout().add(component);
        browser.addBrowserListener(new BrowserListener<T>(){

            @Override
            public void query() {
            }

            @Override
            public void selected(T object) {
                BrowserDialog.this.onSelected(object);
            }

            @Override
            public void browsed(T object) {
                BrowserDialog.this.onBrowsed(object);
            }
        });
        this.getFocusGroup().add(0, browser.getFocusGroup());
        this.browser = browser;
    }

    protected void onOK() {
        if (this.isSelected()) {
            super.onOK();
        }
    }

    protected void setSelected(T object) {
        this.selected = object;
    }

    protected void onSelected(T object) {
        this.setSelected(object);
        if (this.closeOnSelection) {
            this.onOK();
        }
    }

    protected void onBrowsed(T object) {
        this.setSelected(object);
    }

    protected void onNew() {
        this.createNew = true;
        this.close(NEW_ID);
    }
}

