/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Component;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.echo.focus.FocusGroup;

public abstract class BrowserAdapter<A, T>
implements Browser<T> {
    private Browser<A> browser;
    private Map<BrowserListener<T>, BrowserListener<A>> listeners = new HashMap<BrowserListener<T>, BrowserListener<A>>();

    public BrowserAdapter() {
    }

    public BrowserAdapter(Browser<A> browser) {
        this.browser = browser;
    }

    @Override
    public Component getComponent() {
        return this.browser.getComponent();
    }

    @Override
    public T getSelected() {
        A selected = this.browser.getSelected();
        return selected != null ? (T)this.convert(selected) : null;
    }

    @Override
    public boolean setSelected(T object) {
        boolean result = false;
        if (object == null) {
            this.browser.setSelected(null);
        } else {
            for (A target : this.browser.getObjects()) {
                T converted = this.convert(target);
                if (converted == null || !converted.equals(object)) continue;
                result = this.browser.setSelected(target);
                break;
            }
        }
        return result;
    }

    @Override
    public List<T> getObjects() {
        ArrayList<T> result = new ArrayList<T>();
        for (A object : this.browser.getObjects()) {
            result.add(this.convert(object));
        }
        return result;
    }

    @Override
    public void addBrowserListener(BrowserListener<T> listener) {
        BrowserListener<A> l = this.adapt(listener);
        this.browser.addBrowserListener(l);
        this.listeners.put(listener, l);
    }

    @Override
    public void removeBrowserListener(BrowserListener<T> listener) {
        BrowserListener<A> l = this.listeners.remove(listener);
        this.browser.removeBrowserListener(l);
    }

    @Override
    public void query() {
        this.browser.query();
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.browser.getFocusGroup();
    }

    @Override
    public void setFocusOnResults() {
        this.getBrowser().setFocusOnResults();
    }

    public Browser<A> getBrowser() {
        return this.browser;
    }

    @Override
    public BrowserState getBrowserState() {
        return this.browser.getBrowserState();
    }

    @Override
    public void setBrowserState(BrowserState state) {
        this.browser.setBrowserState(state);
    }

    protected BrowserListener<A> adapt(final BrowserListener<T> listener) {
        return new BrowserListener<A>(){

            @Override
            public void query() {
                listener.query();
            }

            @Override
            public void selected(A object) {
                listener.selected(BrowserAdapter.this.convert(object));
            }

            @Override
            public void browsed(A object) {
                listener.browsed(BrowserAdapter.this.convert(object));
            }
        };
    }

    protected void setBrowser(Browser<A> browser) {
        this.browser = browser;
    }

    protected abstract T convert(A var1);
}

