/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractResultSet;
import org.openvpms.web.component.im.query.QueryExecutor;

public class ArchetypeQueryResultSet<T>
extends AbstractResultSet<T> {
    private final ArchetypeQuery query;
    private SortConstraint[] sort;
    private final QueryExecutor<T> executor;
    private IPage<T> lastPage;
    private int lastIndex = -1;

    public ArchetypeQueryResultSet(ArchetypeQuery query, int pageSize, QueryExecutor<T> executor) {
        super(pageSize);
        this.query = query;
        this.executor = executor;
    }

    @Override
    public void sort(SortConstraint[] sort) {
        this.removeSort();
        this.addSort(sort);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.lastPage = null;
        this.lastIndex = -1;
    }

    @Override
    public int getResults() {
        this.query.setCountResults(true);
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        return service.get((IArchetypeQuery)this.query).getTotalResults();
    }

    @Override
    public int getEstimatedResults() {
        return this.getResults();
    }

    @Override
    public boolean isEstimatedActual() {
        return true;
    }

    @Override
    public boolean isSortedAscending() {
        return this.sort != null && this.sort.length != 0 && this.sort[0].isAscending();
    }

    @Override
    public SortConstraint[] getSortConstraints() {
        return this.sort != null ? this.sort : new SortConstraint[]{};
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.query.setDistinct(distinct);
    }

    @Override
    public boolean isDistinct() {
        return this.query.isDistinct();
    }

    @Override
    protected IPage<T> get(int page) {
        IPage<T> result;
        if (page != this.lastIndex) {
            int firstResult = this.getFirstResult(page);
            int pageSize = this.getPageSize();
            this.query.setCountResults(false);
            this.query.setFirstResult(firstResult);
            this.query.setMaxResults(pageSize);
            result = this.executor.query(this.query, this.getNodes());
            if (result.getResults().isEmpty()) {
                result = null;
            }
            this.lastIndex = page;
            this.lastPage = result;
        } else {
            result = this.lastPage;
        }
        return result;
    }

    private void removeSort() {
        if (this.sort != null) {
            for (SortConstraint s : this.sort) {
                this.query.remove((IConstraint)s);
            }
        }
        this.sort = null;
    }

    private void addSort(SortConstraint[] sort) {
        if (sort != null) {
            for (SortConstraint s : sort) {
                this.query.add((IConstraint)s);
            }
        }
        this.sort = sort;
    }
}

