/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.web.component.im.lookup.LookupFilter;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;

public class ActStatuses
implements LookupQuery {
    private final LookupQuery lookups;
    private final String exclude;
    private Lookup defaultLookup;
    private boolean useDefault;

    public ActStatuses(String shortName) {
        this(shortName, null);
    }

    public ActStatuses(String shortName, String exclude) {
        this(new NodeLookupQuery(shortName, "status"), exclude);
    }

    public ActStatuses(LookupQuery lookups) {
        this(lookups, null);
    }

    public ActStatuses(LookupQuery lookups, String exclude) {
        if (exclude != null) {
            lookups = new LookupFilter(lookups, false, exclude);
        }
        this.lookups = lookups;
        this.exclude = exclude;
    }

    public void setDefault(Lookup lookup) {
        this.useDefault = true;
        this.defaultLookup = lookup;
    }

    public void setDefault(String code) {
        this.useDefault = true;
        Lookup lookup = null;
        if (code != null) {
            for (Lookup l : this.getLookups()) {
                if (!l.getCode().equals(code)) continue;
                lookup = l;
            }
        }
        this.defaultLookup = lookup;
    }

    @Override
    public Lookup getDefault() {
        return this.useDefault ? this.defaultLookup : this.lookups.getDefault();
    }

    public String getDefaultCode() {
        Lookup result = this.getDefault();
        return result != null ? result.getCode() : null;
    }

    @Override
    public List<Lookup> getLookups() {
        return this.lookups.getLookups();
    }

    @Override
    public Lookup getLookup(String code) {
        return this.lookups.getLookup(code);
    }

    public List<String> getCodes() {
        ArrayList<String> result = new ArrayList<String>();
        for (Lookup lookup : this.getLookups()) {
            result.add(lookup.getCode());
        }
        return result;
    }

    public String getExcluded() {
        return this.exclude;
    }
}

