/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractBrowser;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusHelper;

public abstract class AbstractTableBrowser<T>
extends AbstractBrowser<T> {
    protected static final String STYLE = "Browser";
    private final LayoutContext context;
    private Component component;
    private PagedIMTable<T> table;
    private IMTableModel<T> model;
    private boolean createModel;
    private boolean initialLayout = true;
    private boolean resultsLayout = false;

    public AbstractTableBrowser(IMTableModel<T> model, LayoutContext context) {
        this.model = model;
        this.context = context;
        boolean bl = this.createModel = model == null;
        if (model != null) {
            this.initTableModel(model);
        }
    }

    @Override
    public T getSelected() {
        return this.table != null ? (T)this.table.getTable().getSelected() : null;
    }

    @Override
    public boolean setSelected(T object) {
        return this.getTable().getTable().setSelected(object);
    }

    @Override
    public List<T> getObjects() {
        return this.model != null ? this.model.getObjects() : Collections.emptyList();
    }

    @Override
    public void setFocusOnResults() {
        IMTable<T> table = this.getTable().getTable();
        if (!table.getObjects().isEmpty() && table.isFocusTraversalParticipant()) {
            FocusHelper.setFocus(table);
        }
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            this.doLayout();
        }
        return this.component;
    }

    protected void doLayout() {
        SplitPane container = SplitPaneFactory.create((int)5, (String)STYLE, (Component[])new Component[0]);
        this.doLayout((Component)container);
        this.setComponent((Component)container);
    }

    protected void setComponent(Component component) {
        this.component = component;
    }

    protected abstract void doLayout(Component var1);

    protected boolean hasResults(ResultSet<T> set) {
        IPage<T> page;
        boolean hasResults = false;
        if (set != null && (page = set.getPage(0)) != null) {
            hasResults = !page.getResults().isEmpty();
        }
        return hasResults;
    }

    protected void doLayoutForResults(Component container) {
        PagedIMTable<T> table = this.getTable();
        container.add(table.getComponent());
        this.getFocusGroup().add(table.getFocusGroup());
    }

    protected void doLayoutForNoResults(Component container) {
        Label label = LabelFactory.create((String)"browser.noresults", (String)"bold");
        label.setLayoutData((LayoutData)ColumnFactory.layout((Alignment)Alignment.ALIGN_CENTER));
        Column wrapper = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{label});
        if (container instanceof SplitPane) {
            wrapper.setLayoutData((LayoutData)SplitPaneFactory.layout((Alignment)Alignment.ALIGN_CENTER));
        } else if (container instanceof Column) {
            wrapper.setLayoutData((LayoutData)ColumnFactory.layout((Alignment)Alignment.ALIGN_CENTER));
        }
        container.add((Component)wrapper);
    }

    protected PagedIMTable<T> createTable(IMTableModel<T> model) {
        return new PagedIMTable<T>(model, true);
    }

    protected PagedIMTable<T> getTable() {
        if (this.table == null) {
            if (this.model == null) {
                this.model = this.createTableModel(this.context);
                this.initTableModel(this.model);
            }
            this.table = this.createTable(this.model);
            this.table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent e) {
                    AbstractTableBrowser.this.onSelect();
                }
            });
            this.table.getTable().addPropertyChangeListener("selection", evt -> this.onBrowse());
        }
        return this.table;
    }

    protected PagedIMTable<T> getTable(boolean create) {
        return this.table == null && create ? this.getTable() : this.table;
    }

    protected IMTableModel<T> createTableModel(LayoutContext context) {
        throw new IllegalStateException("No table model has been registered");
    }

    protected IMTableModel<T> getTableModel() {
        return this.model;
    }

    protected void initTableModel(IMTableModel<T> model) {
    }

    protected LayoutContext getContext() {
        return this.context;
    }

    protected void doLayout(Component container, boolean hasResults) {
        if (this.createModel) {
            this.destroyTable();
            this.initialLayout = true;
        }
        if (this.initialLayout || hasResults != this.resultsLayout) {
            this.switchLayout(container, hasResults);
            this.initialLayout = false;
        }
        this.resultsLayout = hasResults;
    }

    private void switchLayout(Component container, boolean results) {
        this.destroyTable();
        container.removeAll();
        this.doLayout(container);
        if (results) {
            this.doLayoutForResults(container);
        } else {
            this.doLayoutForNoResults(container);
        }
    }

    private void destroyTable() {
        if (this.table != null) {
            this.getFocusGroup().remove(this.table.getFocusGroup());
            this.table = null;
        }
        if (this.createModel) {
            this.model = null;
        }
    }

    private void onSelect() {
        T selected = this.getSelected();
        if (selected != null) {
            this.notifySelected(selected);
        }
    }

    private void onBrowse() {
        T selected = this.getSelected();
        if (selected != null) {
            this.notifyBrowsed(selected);
        }
    }
}

