/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryState;

public abstract class AbstractQueryState
implements QueryState {
    private final Class type;
    private final Set<String> shortNames;

    public AbstractQueryState(Query query) {
        this.type = query.getType();
        this.shortNames = new HashSet<String>(Arrays.asList(query.getShortNames()));
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public String[] getShortNames() {
        return this.shortNames.toArray(new String[this.shortNames.size()]);
    }

    @Override
    public boolean supports(String[] shortNames) {
        return this.shortNames.size() == shortNames.length && this.shortNames.containsAll(Arrays.asList(shortNames));
    }

    @Override
    public boolean supports(Class type, String[] shortNames) {
        return this.type.equals(type) && this.supports(shortNames);
    }
}

