/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractIMObjectResultSet;
import org.openvpms.web.component.im.query.QueryExecutor;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractEntityResultSet<T>
extends AbstractIMObjectResultSet<T> {
    private String[] identityShortNames;
    private final boolean searchAll;

    public AbstractEntityResultSet(ShortNameConstraint archetypes, String value, boolean searchIdentities, IConstraint constraints, SortConstraint[] sort, int rows, boolean distinct, QueryExecutor<T> executor) {
        this(archetypes, value, searchIdentities, false, constraints, sort, rows, distinct, executor);
    }

    public AbstractEntityResultSet(ShortNameConstraint archetypes, String value, boolean searchIdentities, boolean searchAll, IConstraint constraints, SortConstraint[] sort, int rows, boolean distinct, QueryExecutor<T> executor) {
        super(archetypes, value, constraints, sort, rows, distinct, executor);
        if (searchIdentities) {
            HashSet<String> shortNames = new HashSet<String>();
            List<ArchetypeDescriptor> matches = this.getArchetypes(archetypes);
            boolean identities = true;
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            for (ArchetypeDescriptor archetype : matches) {
                NodeDescriptor descriptor = archetype.getNodeDescriptor("identities");
                if (descriptor == null) {
                    identities = false;
                    break;
                }
                shortNames.addAll(Arrays.asList(DescriptorHelper.getShortNames((org.openvpms.component.model.archetype.NodeDescriptor)descriptor, (ArchetypeService)service)));
            }
            if (identities && !shortNames.isEmpty()) {
                this.identityShortNames = shortNames.toArray(new String[0]);
            }
        }
        this.searchAll = searchAll;
    }

    public boolean isSearchingIdentities() {
        return this.identityShortNames != null;
    }

    @Override
    protected ArchetypeQuery createQuery(ShortNameConstraint archetypes) {
        ArchetypeQuery query = super.createQuery(archetypes);
        this.addIdentityConstraints(query);
        return query;
    }

    protected void addIdentityConstraints(ArchetypeQuery query) {
        if (this.isSearchingIdentities()) {
            query.add((IConstraint)Constraints.leftJoin((String)"identities", (BaseArchetypeConstraint)Constraints.shortName((String)"identity", (String[])this.identityShortNames, (boolean)true)));
        }
    }

    @Override
    protected List<IConstraint> createValueConstraints(String value, List<String> nodes) {
        ArrayList<IConstraint> constraints;
        boolean idSearch = this.isSearchingIdentities();
        ArrayList<IConstraint> arrayList = constraints = !idSearch || this.searchAll ? super.createValueConstraints(value, nodes) : new ArrayList<IConstraint>();
        if (idSearch && !StringUtils.isEmpty((CharSequence)this.getValue())) {
            Long id = this.getId(value);
            if (id != null) {
                constraints.add((IConstraint)Constraints.eq((String)"id", (Object)id));
            }
            constraints.add((IConstraint)Constraints.eq((String)"identity.name", (Object)value));
        }
        return constraints;
    }
}

