/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.ArchetypeSortConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractCachingResultSet;
import org.openvpms.web.component.im.query.QueryExecutor;

public abstract class AbstractArchetypeServiceResultSet<T>
extends AbstractCachingResultSet<T> {
    private final IConstraint constraints;
    private final QueryExecutor<T> executor;
    private boolean distinct;
    private SortConstraint[] sort;
    private Reference reference;

    public AbstractArchetypeServiceResultSet(int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        this(null, pageSize, sort, executor);
    }

    public AbstractArchetypeServiceResultSet(IConstraint constraints, int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        super(pageSize);
        this.constraints = constraints;
        this.executor = executor;
        this.setSortConstraint(sort);
    }

    @Override
    public void sort(SortConstraint[] sort) {
        this.setSortConstraint(sort);
        this.reset();
    }

    @Override
    public boolean isSortedAscending() {
        return this.sort.length == 0 || this.sort[0].isAscending();
    }

    @Override
    public SortConstraint[] getSortConstraints() {
        return this.sort;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    public void setReferenceConstraint(Reference reference) {
        this.reference = reference;
    }

    public Reference getReferenceConstraint() {
        return this.reference;
    }

    protected void setSortConstraint(SortConstraint[] sort) {
        this.sort = sort != null ? sort : new SortConstraint[]{};
    }

    protected IConstraint getConstraints() {
        return this.constraints;
    }

    protected abstract ArchetypeQuery createQuery();

    protected ArchetypeQuery createQuery(int firstResult, int maxResults) {
        ArchetypeQuery query = this.createQuery();
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        query.setDistinct(this.isDistinct());
        query.setCountResults(false);
        IConstraint constraints = this.getConstraints();
        if (constraints != null) {
            query.add(constraints);
        }
        if (this.reference != null) {
            this.addReferenceConstraint(query, this.reference);
        }
        this.addSortConstraints(query);
        return query;
    }

    protected void addReferenceConstraint(ArchetypeQuery query, Reference reference) {
        query.add((IConstraint)new ObjectRefConstraint(reference));
    }

    protected void addSortConstraints(ArchetypeQuery query) {
        String alias = query.getArchetypeConstraint().getAlias();
        for (SortConstraint sort : this.getSortConstraints()) {
            if (alias != null && sort.getAlias() == null) {
                NodeSortConstraint o;
                if (sort instanceof NodeSortConstraint) {
                    o = (NodeSortConstraint)sort;
                    sort = new NodeSortConstraint(alias, o.getNodeName(), o.isAscending());
                } else if (sort instanceof ArchetypeSortConstraint) {
                    o = (ArchetypeSortConstraint)sort;
                    sort = new ArchetypeSortConstraint(alias, o.isAscending());
                }
            }
            query.add((IConstraint)sort);
        }
    }

    @Override
    protected IPage<T> query(int firstResult, int maxResults) {
        ArchetypeQuery query = this.createQuery(firstResult, maxResults);
        String[] nodes = this.getNodes();
        return this.executor.query(query, nodes);
    }

    @Override
    protected int countResults() {
        ArchetypeQuery query = this.createQuery(0, 0);
        query.setCountResults(true);
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        return service.get((IArchetypeQuery)query).getTotalResults();
    }

    protected Long getId(String value) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            value = value.replaceAll(",", "").replaceAll("\\*", "");
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

