/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.io.Serializable;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.CharSetUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.list.ShortNameListCellRenderer;
import org.openvpms.web.component.im.list.ShortNameListModel;
import org.openvpms.web.component.im.query.AbstractArchetypeServiceResultSet;
import org.openvpms.web.component.im.query.AbstractQuery;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;

public abstract class AbstractArchetypeQuery<T>
extends AbstractQuery<T> {
    protected static final SortConstraint[] NAME_SORT_CONSTRAINT = new SortConstraint[]{Constraints.sort((String)"name"), Constraints.sort((String)"id")};
    private final ShortNameConstraint archetypes;
    private final FocusGroup focusGroup = new FocusGroup(this.getClass().getName());
    private TextField searchField;
    private SelectField activeSelector;
    private String shortName;
    private Component component;
    private static final String TYPE_ID = "query.type";
    private static final String SEARCH_ID = "query.search";
    private static final String ACTIVE_ID = "query.active";
    private static final String[] ACTIVE_CHOICES = new String[]{"query.active.yes", "query.active.no", "query.active.both"};
    private static final int ACTIVE_YES = 0;
    private static final int ACTIVE_NO = 1;
    private static final int ACTIVE_BOTH = 2;

    public AbstractArchetypeQuery(String[] shortNames, Class type) {
        this(shortNames, true, type);
    }

    public AbstractArchetypeQuery(String[] shortNames, boolean primaryOnly, Class type) {
        super(shortNames, primaryOnly, type);
        this.archetypes = new ShortNameConstraint(this.getShortNames(), primaryOnly, true);
    }

    public AbstractArchetypeQuery(String[] shortNames, boolean primaryOnly) {
        super(shortNames, primaryOnly);
        this.archetypes = new ShortNameConstraint(this.getShortNames(), primaryOnly, true);
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            this.component = this.createContainer();
            this.doLayout(this.component);
        }
        return this.component;
    }

    public void setActiveOnly(boolean active) {
        this.getActiveSelector().setSelectedItem((Object)(active ? ACTIVE_CHOICES[0] : ACTIVE_CHOICES[2]));
    }

    @Override
    public ResultSet<T> query(SortConstraint[] sort) {
        return this.createResultSet(sort);
    }

    @Override
    public boolean selects(T object) {
        return object instanceof IMObject && this.selects(((IMObject)object).getObjectReference());
    }

    @Override
    public boolean selects(Reference reference) {
        boolean result;
        ResultSet set = this.query();
        if (set instanceof AbstractArchetypeServiceResultSet) {
            ((AbstractArchetypeServiceResultSet)set).setReferenceConstraint(reference);
            result = set.hasNext();
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void setValue(String value) {
        this.getSearchField().setText(value);
    }

    @Override
    public String getValue() {
        return this.getWildcardedText((TextComponent)this.getSearchField());
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    public String getShortName() {
        return this.shortName;
    }

    @Override
    public BaseArchetypeConstraint.State getActive() {
        if (this.activeSelector != null) {
            switch (this.activeSelector.getSelectedIndex()) {
                case 0: {
                    return BaseArchetypeConstraint.State.ACTIVE;
                }
                case 1: {
                    return BaseArchetypeConstraint.State.INACTIVE;
                }
            }
            return BaseArchetypeConstraint.State.BOTH;
        }
        return BaseArchetypeConstraint.State.ACTIVE;
    }

    public void setActive(BaseArchetypeConstraint.State state) {
        if (this.activeSelector != null) {
            switch (state) {
                case ACTIVE: {
                    this.activeSelector.setSelectedIndex(0);
                    break;
                }
                case INACTIVE: {
                    this.activeSelector.setSelectedIndex(1);
                    break;
                }
                default: {
                    this.activeSelector.setSelectedIndex(2);
                }
            }
        }
    }

    public ShortNameConstraint getArchetypes() {
        return this.archetypes;
    }

    protected abstract ResultSet<T> createResultSet(SortConstraint[] var1);

    protected boolean isPrimaryOnly() {
        return this.getArchetypes().isPrimaryOnly();
    }

    protected ShortNameConstraint getArchetypeConstraint() {
        ShortNameConstraint result;
        String type = this.getShortName();
        if (type == null) {
            result = this.getArchetypes();
            result.setState(this.getActive());
        } else {
            result = new ShortNameConstraint(type, this.isPrimaryOnly(), this.getActive());
        }
        return result;
    }

    protected void setShortName(String name) {
        this.shortName = name;
    }

    protected Component createContainer() {
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
    }

    protected void doLayout(Component container) {
        this.addShortNameSelector(container);
        this.addSearchField(container);
        this.addActive(container);
        FocusHelper.setFocus((Component)this.getSearchField());
    }

    protected void addShortNameSelector(Component container) {
        String[] shortNames = this.getShortNames();
        if (shortNames.length > 1) {
            ShortNameListModel model = new ShortNameListModel(shortNames, true);
            SelectField shortNameSelector = SelectFieldFactory.create((ListModel)model);
            shortNameSelector.addPropertyChangeListener(evt -> {
                int index = shortNameSelector.getSelectedIndex();
                String shortName = index >= 0 ? model.getShortName(index) : null;
                this.setShortName(shortName);
                this.onShortNameChanged();
            });
            shortNameSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    AbstractArchetypeQuery.this.onQuery();
                }
            });
            shortNameSelector.setCellRenderer((ListCellRenderer)new ShortNameListCellRenderer());
            Label typeLabel = LabelFactory.create((String)TYPE_ID);
            container.add((Component)typeLabel);
            container.add((Component)shortNameSelector);
            this.focusGroup.add((Component)shortNameSelector);
        }
    }

    protected TextField getSearchField() {
        if (this.searchField == null) {
            this.searchField = TextComponentFactory.create();
            this.searchField.addPropertyChangeListener("text", evt -> this.onSearchFieldChanged());
            this.searchField.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    AbstractArchetypeQuery.this.onQuery();
                }
            });
        }
        return this.searchField;
    }

    protected void addSearchField(Component container) {
        Label label = LabelFactory.create((String)SEARCH_ID);
        container.add((Component)label);
        container.add((Component)this.getSearchField());
        this.focusGroup.add((Component)this.searchField);
    }

    protected SelectField getActiveSelector() {
        if (this.activeSelector == null) {
            DefaultListModel model = new DefaultListModel((Object[])ACTIVE_CHOICES);
            this.activeSelector = SelectFieldFactory.create((ListModel)model);
            this.activeSelector.setSelectedIndex(0);
            this.activeSelector.setCellRenderer((ListCellRenderer & Serializable)(list, value, index) -> Messages.get((String)value.toString()));
            this.activeSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    AbstractArchetypeQuery.this.onQuery();
                }
            });
        }
        return this.activeSelector;
    }

    protected void addActive(Component container) {
        container.add((Component)LabelFactory.create((String)ACTIVE_ID));
        SelectField component = this.getActiveSelector();
        this.focusGroup.add((Component)component);
        if (container instanceof Grid) {
            component = RowFactory.create((Component[])new Component[]{component});
        }
        container.add((Component)component);
    }

    protected void onSearchFieldChanged() {
    }

    protected void onShortNameChanged() {
    }

    protected boolean canQueryOnName() {
        String name = this.getValue();
        int length = 0;
        if (name != null) {
            length = CharSetUtils.delete((String)name, (String[])new String[]{"*"}).length();
        }
        return length >= this.getValueMinLength();
    }

    protected String getWildcardedText(TextComponent field) {
        return this.getWildcardedText(field, this.isContains());
    }

    protected String getWildcardedText(TextComponent field, boolean substring) {
        String text = StringUtils.trimToNull((String)field.getText());
        String wildcard = "*";
        if (text != null && !text.contains("*")) {
            text = text + "*";
            if (substring) {
                text = "*" + text;
            }
        }
        return text;
    }
}

