/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.Objects;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductEditor;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public class ProductTemplateEditor
extends ProductEditor {
    public ProductTemplateEditor(Product object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateIncludes(validator);
    }

    protected boolean validateIncludes(Validator validator) {
        boolean valid = true;
        IMObject object = this.getObject();
        if (!object.isNew()) {
            Reference reference = object.getObjectReference();
            CollectionProperty property = this.getCollectionProperty("includes");
            for (Object value : property.getValues()) {
                Relationship relationship = (Relationship)value;
                if (!Objects.equals(reference, relationship.getTarget())) continue;
                String message = Messages.format((String)"product.template.includeself", (Object[])new Object[]{object.getName()});
                validator.add((Modifiable)property, new ValidatorError(property, message));
                valid = false;
            }
        }
        return valid;
    }
}

