/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import org.openvpms.component.business.domain.im.common.EntityLink;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.RelationshipDescriptorTableModel;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.system.ServiceHelper;

public class ProductSupplierTableModel
extends RelationshipDescriptorTableModel<EntityLink> {
    private final IArchetypeService service = ServiceHelper.getArchetypeService();
    private static final String[] NODES = new String[]{"description", "preferred", "packageSize", "packageUnits", "listPrice", "nettPrice"};

    public ProductSupplierTableModel(String[] shortNames, LayoutContext context) {
        super(shortNames, context, true);
    }

    @Override
    protected Object getValue(EntityLink object, DescriptorTableColumn column, int row) {
        Object result;
        if ("description".equals(column.getName())) {
            IMObjectBean bean = this.service.getBean((IMObject)object);
            result = bean.getString("reorderDescription");
            if (result == null) {
                result = bean.getString("reorderCode");
            }
        } else {
            result = super.getValue(object, column, row);
        }
        return result;
    }

    @Override
    protected String[] getNodeNames() {
        return NODES;
    }
}

