/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.product.PricingGroupSelectField;
import org.openvpms.web.component.im.product.ProductResultSet;
import org.openvpms.web.component.im.query.AbstractEntityQuery;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.system.ServiceHelper;

public class ProductQuery
extends AbstractEntityQuery<Product> {
    private final SimpleProperty productType = SimpleProperty.newProperty().name("productType").type(Entity.class).displayNameKey("product.export.productType").build();
    private String species;
    private boolean useLocationProducts;
    private Party location;
    private Party stockLocation;
    private PricingGroup pricingGroup;
    private boolean excludeTemplateOnlyProducts;
    private static final String STARTS_WITH = "STARTS_WITH";

    public ProductQuery(String[] shortNames, Context context) {
        super(shortNames, Product.class);
        this.setLocation(context.getLocation());
        Settings settings = ServiceHelper.getBean(Settings.class);
        String type = settings.getString("entity.globalSettingsQuery", "productNameSearch", STARTS_WITH);
        this.setContains(!STARTS_WITH.equals(type));
    }

    public void setProductType(Entity productType) {
        this.productType.setValue(productType);
    }

    public Entity getProductType() {
        return (Entity)this.productType.getValue();
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setLocation(Party location) {
        this.location = location;
        if (location != null) {
            LocationRules rules = ServiceHelper.getBean(LocationRules.class);
            this.pricingGroup = new PricingGroup(rules.getPricingGroup(location));
        } else {
            this.pricingGroup = new PricingGroup(null);
        }
    }

    public void setStockLocation(Party location) {
        this.stockLocation = location;
    }

    public Party getStockLocation() {
        return this.stockLocation;
    }

    public PricingGroup getPricingGroup() {
        return this.pricingGroup;
    }

    public void setExcludeTemplateOnlyProducts(boolean exclude) {
        this.excludeTemplateOnlyProducts = exclude;
    }

    public void setUseLocationProducts(boolean useLocationProducts) {
        this.useLocationProducts = useLocationProducts;
    }

    public boolean useLocationProducts() {
        return this.useLocationProducts;
    }

    @Override
    public boolean selects(Reference reference) {
        boolean result;
        if (!this.excludeTemplateOnlyProducts) {
            result = super.selects(reference);
        } else {
            ProductResultSet set = this.getResultSet(this.getDefaultSortConstraint());
            set.setReferenceConstraint(reference);
            ResultSet<Product> filtered = this.filterTemplateOnlyProducts(set);
            result = filtered.hasNext();
        }
        return result;
    }

    @Override
    protected Component createContainer() {
        return GridFactory.create((int)8);
    }

    @Override
    public Extent getHeight() {
        return this.getHeight(2);
    }

    @Override
    protected void doLayout(Component container) {
        super.doLayout(container);
        this.addProductTypeSelector(container);
    }

    protected void setPricingGroup(PricingGroup group) {
        this.pricingGroup = group;
    }

    @Override
    protected ResultSet<Product> createResultSet(SortConstraint[] sort) {
        ResultSet<Product> result = this.getResultSet(sort);
        if (this.excludeTemplateOnlyProducts) {
            result = this.filterTemplateOnlyProducts(result);
        }
        return result;
    }

    protected void addPricingGroupSelector(Component container, boolean all) {
        final PricingGroupSelectField field = new PricingGroupSelectField(this.pricingGroup, all);
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                PricingGroup group = field.isAllSelected() ? PricingGroup.ALL : field.getSelected();
                ProductQuery.this.onPricingGroupChanged(group);
            }
        });
        Label label = LabelFactory.create((String)"product.pricingGroup");
        container.add((Component)label);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    protected void onPricingGroupChanged(PricingGroup group) {
        this.pricingGroup = group;
    }

    protected ResultSet<Product> filterTemplateOnlyProducts(ResultSet<Product> set) {
        return new FilteredResultSet<Product>(set){

            @Override
            protected void filter(Product object, List<Product> results) {
                IMObjectBean bean = ProductQuery.this.getService().getBean((IMObject)object);
                if (!bean.hasNode("templateOnly") || !bean.getBoolean("templateOnly")) {
                    results.add(object);
                }
            }
        };
    }

    protected ProductResultSet getResultSet(SortConstraint[] sort) {
        return new ProductResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), (Entity)this.productType.getValue(), this.species, this.useLocationProducts, this.location, this.stockLocation, sort, this.getMaxResults());
    }

    private void addProductTypeSelector(Component container) {
        ArchetypeQuery query = new ArchetypeQuery("entity.productType", true).add((IConstraint)Constraints.sort((String)"name")).setMaxResults(-1);
        IMObjectListModel model = new IMObjectListModel(QueryHelper.query(query), true, false);
        SelectField field = BoundSelectFieldFactory.create(this.productType, (ListModel)model);
        field.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        Label label = LabelFactory.create();
        label.setText(this.productType.getDisplayName());
        container.add((Component)label);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }
}

