/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ServiceRatioService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.product.AbstractPricingContext;
import org.openvpms.web.system.ServiceHelper;

public class ProductPricingContext
extends AbstractPricingContext {
    private final boolean includeTax;
    private final ArchetypeService service = ServiceHelper.getArchetypeService();
    private final TaxRules taxRules;

    public ProductPricingContext(Currency currency, Party practice, Party location, ProductPriceRules priceRules, LocationRules locationRules, ServiceRatioService serviceRatios) {
        super(currency, location, priceRules, locationRules, serviceRatios);
        this.taxRules = new TaxRules(practice, this.service);
        this.includeTax = this.includeTax(practice);
    }

    public ProductPricingContext(Currency currency, PricingGroup pricingGroup, Party practice, Party location, ProductPriceRules priceRules, ServiceRatioService serviceRatios) {
        super(currency, pricingGroup, location, priceRules, serviceRatios);
        this.taxRules = new TaxRules(practice, this.service);
        this.includeTax = this.includeTax(practice);
    }

    @Override
    public BigDecimal getPrice(Product product, ProductPrice price, BigDecimal serviceRatio) {
        BigDecimal result;
        if (this.includeTax) {
            result = super.getPrice(product, price, serviceRatio);
        } else {
            BigDecimal taxExPrice = price.getPrice();
            if (taxExPrice != null) {
                if (serviceRatio != null) {
                    taxExPrice = taxExPrice.multiply(serviceRatio);
                }
                result = this.getCurrency().round(taxExPrice);
            } else {
                result = BigDecimal.ZERO;
            }
        }
        return result;
    }

    @Override
    protected BigDecimal getTaxRate(Product product) {
        return this.includeTax ? this.taxRules.getTaxRate(product) : BigDecimal.ZERO;
    }

    protected boolean includeTax(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        return bean.getBoolean("showPricesTaxInclusive", true);
    }
}

