/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.bound.BoundDateFieldFactory;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectTableCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.PricingGroupFilter;
import org.openvpms.web.component.im.product.ProductPriceEditor;
import org.openvpms.web.component.im.product.ProductPriceTableModel;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;

public class ProductPriceCollectionEditor
extends IMObjectTableCollectionEditor {
    private final ProductPriceRules rules;
    private final PricingGroupFilter filter;
    private static final String PRICING_GROUPS = "pricingGroups";
    private static final String COPY_ID = "button.copy";
    private static final String COPY_AND_CLOSE_ID = "button.copyAndClose";

    public ProductPriceCollectionEditor(CollectionProperty property, IMObject object, LayoutContext context) {
        super(property, object, context);
        this.filter = new PricingGroupFilter(context);
        this.rules = ServiceHelper.getBean(ProductPriceRules.class);
    }

    @Override
    public ProductPriceEditor getCurrentEditor() {
        return (ProductPriceEditor)super.getCurrentEditor();
    }

    @Override
    public IMObject create() {
        IMObject object = super.create();
        PricingGroup pricingGroup = this.filter.getPricingGroup();
        if (object != null && pricingGroup != null && pricingGroup.getGroup() != null) {
            IMObjectBean bean = this.getBean(object);
            bean.addValue(PRICING_GROUPS, (IMObject)pricingGroup.getGroup());
        }
        return object;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateUnitPrices(validator);
    }

    protected ProductPrice getSelected() {
        return (ProductPrice)super.getSelected();
    }

    protected void copyAndClose() {
        final ProductPrice selected = this.getSelected();
        if (selected != null) {
            final NewPricePrompt prompt = new NewPricePrompt(selected);
            prompt.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    ProductPriceCollectionEditor.this.doCopyAndClose(selected, prompt.getFromDate());
                }
            });
            prompt.show();
        }
    }

    @Override
    protected ButtonRow createControls(FocusGroup focus) {
        ButtonRow row = super.createControls(focus);
        if (this.filter.needsFilter()) {
            row.add(this.filter.getComponent());
            this.filter.setListener(new ActionListener(){

                public void onAction(ActionEvent event) {
                    ProductPriceCollectionEditor.this.populateTable();
                }
            });
        }
        return row;
    }

    @Override
    protected void addButtons(ButtonRow buttons) {
        buttons.addButton(COPY_ID, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ProductPriceCollectionEditor.this.copy();
            }
        });
        buttons.addButton(COPY_AND_CLOSE_ID, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ProductPriceCollectionEditor.this.copyAndClose();
            }
        });
        super.addButtons(buttons);
    }

    @Override
    protected void enableNavigation(ButtonSet buttons, boolean enable, boolean enableAdd) {
        if (enable) {
            ProductPrice selected = this.getSelected();
            if (selected != null) {
                boolean hasToDate = selected.getToDate() != null;
                buttons.setEnabled(COPY_AND_CLOSE_ID, !hasToDate);
                buttons.setEnabled(COPY_ID, hasToDate || selected.isFixed());
            }
        } else {
            buttons.setEnabled(COPY_AND_CLOSE_ID, false);
            buttons.setEnabled(COPY_ID, false);
        }
        super.enableNavigation(buttons, enable, enableAdd);
    }

    @Override
    protected boolean getEnableDelete() {
        boolean result = super.getEnableDelete();
        if (result) {
            ProductPriceEditor editor = this.getCurrentEditor();
            result = editor != null && !editor.isReadOnly();
        }
        return result;
    }

    @Override
    protected ButtonSet getButtons() {
        return super.getButtons();
    }

    @Override
    protected ResultSet<IMObject> createResultSet() {
        CollectionPropertyEditor editor = this.getCollectionPropertyEditor();
        List<IMObject> objects = this.filter.getPrices(editor.getObjects());
        return new IMObjectListResultSet<IMObject>(objects, 15);
    }

    @Override
    protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
        context = new DefaultLayoutContext(context);
        context.setComponentFactory(new TableComponentFactory(context));
        ProductPriceTableModel model = new ProductPriceTableModel(this.getProperty().getArchetypeRange(), context);
        if (this.filter.needsFilter()) {
            model.setShowPricingGroups(true);
        }
        return model;
    }

    protected void selectAndEdit(IMObject price) {
        this.setSelected(price);
        this.edit(price);
    }

    private void copy() {
        ProductPrice selected = this.getSelected();
        if (selected != null) {
            Date date = selected.getToDate();
            if (date == null) {
                date = new Date();
            }
            ProductPrice newPrice = this.rules.copy(selected, date);
            this.editNew(newPrice);
        }
    }

    private void doCopyAndClose(ProductPrice price, Date date) {
        ProductPrice newPrice = this.rules.copyAndClose(price, date);
        this.editNew(newPrice);
    }

    private void editNew(ProductPrice newPrice) {
        this.add((IMObject)newPrice);
        this.refresh(false);
        this.selectAndEdit((IMObject)newPrice);
    }

    private boolean validateUnitPrices(Validator validator) {
        boolean valid = true;
        ArrayList<ProductPrice> unitPrices = new ArrayList<ProductPrice>();
        for (IMObject price : this.getCurrentObjects()) {
            if (!price.isA("productPrice.unitPrice")) continue;
            unitPrices.add((ProductPrice)price);
        }
        block1: while (unitPrices.size() > 1) {
            ProductPrice price = (ProductPrice)unitPrices.remove(0);
            for (ProductPrice other : unitPrices) {
                if (!DateRules.intersects((Date)price.getFromDate(), (Date)price.getToDate(), (Date)other.getFromDate(), (Date)other.getToDate())) continue;
                if (DateRules.dateEquals((Date)price.getToDate(), (Date)other.getFromDate())) {
                    this.setToDate(price, other.getFromDate());
                    continue;
                }
                if (DateRules.dateEquals((Date)price.getFromDate(), (Date)other.getToDate())) {
                    this.setToDate(other, price.getFromDate());
                    continue;
                }
                IMObjectBean priceBean = this.getBean((IMObject)price);
                IMObjectBean otherBean = this.getBean((IMObject)other);
                List priceGroups = priceBean.getValues(PRICING_GROUPS, Lookup.class);
                List otherGroups = otherBean.getValues(PRICING_GROUPS, Lookup.class);
                if (priceGroups.isEmpty() && otherGroups.isEmpty()) {
                    validator.add((Modifiable)this.getEditor((IMObject)price), new ValidatorError(Messages.format((String)"product.price.dateOverlap", (Object[])new Object[]{this.formatPrice(price), this.formatPrice(other)})));
                    valid = false;
                    continue block1;
                }
                if (!priceGroups.removeAll(otherGroups)) continue;
                validator.add((Modifiable)this.getEditor((IMObject)price), new ValidatorError(Messages.format((String)"product.price.groupOverlap", (Object[])new Object[]{this.formatPrice(price), this.formatPrice(other)})));
                valid = false;
                continue block1;
            }
        }
        return valid;
    }

    private void setToDate(ProductPrice price, Date date) {
        IMObjectEditor editor = this.getEditor((IMObject)price);
        if (editor instanceof ProductPriceEditor) {
            ((ProductPriceEditor)editor).setToDate(date);
        } else {
            price.setToDate(date);
        }
    }

    private String formatPrice(ProductPrice price) {
        String amount = NumberFormatter.formatCurrency((Number)price.getPrice());
        if (price.getFromDate() != null) {
            String date = DateFormatter.formatDate((Date)price.getFromDate(), (boolean)false);
            return Messages.format((String)"product.price.priceWithStartDate", (Object[])new Object[]{amount, date});
        }
        return Messages.format((String)"product.price.priceWithNoStartDate", (Object[])new Object[]{amount});
    }

    private class NewPricePrompt
    extends ModalDialog {
        private final RadioButton nowOption;
        private final RadioButton fromOption;
        private final String message;
        private final String footnote;
        private final Date minimum;
        private final SimpleProperty fromDate;

        public NewPricePrompt(ProductPrice productPrice) {
            super(null, "MessageDialog", OK_CANCEL);
            this.fromDate = new SimpleProperty("fromDate", Date.class);
            IMObjectBean bean = ProductPriceCollectionEditor.this.getBean((IMObject)productPrice);
            String displayName = bean.getDisplayName();
            this.setTitle(Messages.format((String)"editor.new.title", (Object[])new Object[]{displayName}));
            this.message = Messages.format((String)"product.price.new.message", (Object[])new Object[]{displayName});
            ButtonGroup group = new ButtonGroup();
            this.nowOption = ButtonFactory.create((String)"product.price.start.now", (ButtonGroup)group);
            this.fromOption = ButtonFactory.create((String)"product.price.start.from", (ButtonGroup)group);
            this.footnote = Messages.format((String)"product.price.new.footnote", (Object[])new Object[]{displayName});
            Date to = productPrice.getToDate();
            Date from = productPrice.getFromDate();
            if (to != null) {
                this.fromDate.setValue(to);
            } else {
                Date now = new Date();
                if (from != null && DateRules.compareTo((Date)from, (Date)now) > 0) {
                    this.fromDate.setValue(from);
                } else {
                    this.fromDate.setValue(now);
                }
            }
            this.minimum = from;
        }

        public Date getFromDate() {
            Date result = null;
            if (this.nowOption.isSelected()) {
                result = new Date();
            } else if (this.fromOption.isSelected()) {
                result = this.fromDate.getDate();
            }
            return result;
        }

        protected void onOK() {
            if (this.isValid()) {
                super.onOK();
            }
        }

        protected void doLayout() {
            Column inner = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.text((String)this.message, (String)"bold", (boolean)true), this.nowOption, RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.fromOption, BoundDateFieldFactory.create(this.fromDate)})});
            Column outer = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{inner, LabelFactory.text((String)this.footnote, (boolean)true)});
            this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{outer}));
        }

        private boolean isValid() {
            boolean valid = false;
            Date date = this.getFromDate();
            if (date != null) {
                if (this.minimum == null || DateRules.compareTo((Date)date, (Date)this.minimum) >= 0) {
                    valid = true;
                } else {
                    ErrorDialog.show((String)Messages.get((String)"product.price.start.error"));
                }
            }
            return valid;
        }
    }
}

