/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.NumericPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public class ProductDoseEditor
extends AbstractIMObjectEditor {
    public static final String SPECIES = "species";
    public static final String MIN_WEIGHT = "minWeight";
    public static final String MAX_WEIGHT = "maxWeight";
    public static final String WEIGHT_UNITS = "weightUnits";

    public ProductDoseEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
        Property rate = this.getProperty("rate");
        rate.setTransformer(new NumericPropertyTransformer(rate, true, 3));
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateWeight(validator);
    }

    private boolean validateWeight(Validator validator) {
        BigDecimal max;
        boolean valid = true;
        Property minWeight = this.getProperty(MIN_WEIGHT);
        Property maxWeight = this.getProperty(MAX_WEIGHT);
        BigDecimal min = minWeight.getBigDecimal(BigDecimal.ZERO);
        if (min.compareTo(max = maxWeight.getBigDecimal(BigDecimal.ZERO)) >= 0) {
            validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"product.weighterror", (Object[])new Object[]{min, max})));
            valid = false;
        }
        return valid;
    }
}

