/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.GridLayoutData;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductBatchResultSet;
import org.openvpms.web.component.im.query.AbstractEntityQuery;
import org.openvpms.web.component.im.query.DateRange;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.AbstractSelectorListener;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;

public class ProductBatchQuery
extends AbstractEntityQuery<Entity> {
    private Product product;
    private TextField productName;
    private DateRange expiryDate;
    private final IMObjectSelector<Party> stockLocation;
    private final IMObjectSelector<Party> manufacturer;
    private static final String[] SHORT_NAMES = new String[]{"entity.productBatch"};

    public ProductBatchQuery(LayoutContext context) {
        super(SHORT_NAMES);
        this.setContains(true);
        this.stockLocation = new IMObjectSelector(Messages.get((String)"product.stockLocation"), new DefaultLayoutContext(context, context.getHelpContext()), "party.organisationStockLocation");
        this.stockLocation.setObject(context.getContext().getStockLocation());
        this.manufacturer = new IMObjectSelector(Messages.get((String)"product.batch.manufacturer"), new DefaultLayoutContext(context, context.getHelpContext()), "party.supplierManufacturer");
        AbstractSelectorListener<Party> listener = new AbstractSelectorListener<Party>(){

            @Override
            public void selected(Party object) {
                ProductBatchQuery.this.onQuery();
            }
        };
        this.stockLocation.setListener((SelectorListener<Party>)listener);
        this.manufacturer.setListener((SelectorListener<Party>)listener);
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public void setProductName(String product) {
        this.getProductField().setText(product);
    }

    public String setProductName() {
        return this.getProductField().getText();
    }

    public void setExpireAfter(Date date) {
        this.getExpiryDate().setFrom(date);
    }

    @Override
    public Extent getHeight() {
        return this.getHeight(3);
    }

    @Override
    protected Component createContainer() {
        return GridFactory.create((int)6);
    }

    @Override
    protected void doLayout(Component container) {
        this.addSearchField(container);
        this.addExpiryDate(container);
        if (this.product == null) {
            this.addProductName(container);
        }
        this.addStockLocation(container);
        this.addActive(container);
        this.addManufacturer(container);
        this.getExpiryDate().setFrom(DateRules.getToday());
        this.getExpiryDate().setTo(null);
        FocusHelper.setFocus((Component)this.getSearchField());
    }

    @Override
    protected void addSearchField(Component container) {
        Label label = LabelFactory.create((String)"product.batch");
        container.add((Component)label);
        TextField field = this.getSearchField();
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    protected TextField getProductField() {
        if (this.productName == null) {
            this.productName = TextComponentFactory.create();
            this.productName.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    ProductBatchQuery.this.onQuery();
                }
            });
        }
        return this.productName;
    }

    protected DateRange getExpiryDate() {
        if (this.expiryDate == null) {
            this.expiryDate = new DateRange(false){

                @Override
                protected ComponentState createFromDate(Property from) {
                    ComponentState fromDate = super.createFromDate(from);
                    fromDate.setLabel(LabelFactory.create((String)"product.batch.expiringAfter"));
                    return fromDate;
                }

                @Override
                protected ComponentState createToDate(Property to) {
                    ComponentState toDate = super.createToDate(to);
                    toDate.setLabel(LabelFactory.create((String)"product.batch.expiringBefore"));
                    return toDate;
                }
            };
        }
        return this.expiryDate;
    }

    protected void addProductName(Component container) {
        Label label = LabelFactory.create((String)"product.batch.product");
        container.add((Component)label);
        TextField field = this.getProductField();
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    protected void addStockLocation(Component container) {
        this.addSelector(this.stockLocation, container);
    }

    protected void addManufacturer(Component container) {
        this.addSelector(this.manufacturer, container);
    }

    protected void addExpiryDate(Component container) {
        DateRange dateRange = this.getExpiryDate();
        dateRange.setContainer(container);
        this.getFocusGroup().add(dateRange.getFocusGroup());
    }

    @Override
    protected ResultSet<Entity> createResultSet(SortConstraint[] sort) {
        String productName = this.getWildcardedText((TextComponent)this.getProductField());
        Date from = this.getExpiryDate().getFrom();
        Date to = this.getExpiryDate().getTo();
        Reference location = this.stockLocation.getObject() != null ? ((Party)this.stockLocation.getObject()).getObjectReference() : null;
        return new ProductBatchResultSet(this.getArchetypeConstraint(), this.getValue(), this.product, productName, from, to, location, null, (Party)this.manufacturer.getObject(), sort, this.getMaxResults());
    }

    private void addSelector(IMObjectSelector<Party> selector, Component container) {
        Label label = LabelFactory.create();
        label.setText(selector.getType());
        container.add((Component)label);
        Component component = selector.getComponent();
        container.add(component);
        GridLayoutData layoutData = new GridLayoutData();
        layoutData.setColumnSpan(3);
        component.setLayoutData((LayoutData)layoutData);
        selector.getSelect().setFocusTraversalParticipant(false);
        this.getFocusGroup().add(selector.getFocusGroup());
    }
}

