/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.PricingGroupSelectField;
import org.openvpms.web.component.im.product.ProductHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;

public class PricingGroupFilter {
    private PricingGroup pricingGroup;
    private final boolean needsFilter;
    private boolean showAll;
    private ActionListener listener;

    public PricingGroupFilter(LayoutContext context) {
        this.pricingGroup = ProductHelper.getPricingGroup(context.getContext());
        this.needsFilter = ProductHelper.pricingGroupsConfigured();
    }

    public boolean needsFilter() {
        return this.needsFilter;
    }

    public PricingGroup getPricingGroup() {
        return this.pricingGroup;
    }

    public void setListener(ActionListener listener) {
        this.listener = listener;
    }

    public List<IMObject> getPrices(List<IMObject> prices) {
        if (!this.showAll) {
            return ProductHelper.filterPrices(prices, this.pricingGroup);
        }
        return prices;
    }

    public Component getComponent() {
        final PricingGroupSelectField filter = new PricingGroupSelectField(this.pricingGroup, true);
        filter.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                PricingGroupFilter.this.pricingGroup = filter.getSelected();
                PricingGroupFilter.this.showAll = filter.isAllSelected();
                if (PricingGroupFilter.this.listener != null) {
                    PricingGroupFilter.this.listener.onAction(new ActionEvent((Object)this, null));
                }
            }
        });
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"product.pricingGroup"), filter});
    }
}

