/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ServiceRatioService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.im.product.PricingContext;

public abstract class AbstractPricingContext
implements PricingContext {
    private final Currency currency;
    private final Party location;
    private final ProductPriceRules rules;
    private final ServiceRatioService serviceRatios;
    private PricingGroup pricingGroup;

    public AbstractPricingContext(Currency currency, Party location, ProductPriceRules priceRules, LocationRules locationRules, ServiceRatioService serviceRatios) {
        this.currency = currency;
        this.pricingGroup = this.getPricingGroup(location, locationRules);
        this.location = location;
        this.rules = priceRules;
        this.serviceRatios = serviceRatios;
    }

    public AbstractPricingContext(Currency currency, PricingGroup pricingGroup, Party location, ProductPriceRules priceRules, ServiceRatioService serviceRatios) {
        this.currency = currency;
        this.pricingGroup = pricingGroup;
        this.location = location;
        this.rules = priceRules;
        this.serviceRatios = serviceRatios;
    }

    @Override
    public BigDecimal getPrice(Product product, ProductPrice price, BigDecimal serviceRatio) {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal taxExPrice = price.getPrice();
        if (taxExPrice != null) {
            if (serviceRatio != null) {
                taxExPrice = taxExPrice.multiply(serviceRatio);
            }
            result = this.rules.getTaxIncPrice(taxExPrice, this.getTaxRate(product), this.currency);
        }
        return result;
    }

    @Override
    public List<ProductPrice> getFixedPrices(Product product, Date date) {
        return this.rules.getProductPrices(product, "productPrice.fixedPrice", date, this.pricingGroup);
    }

    @Override
    public ProductPrice getFixedPrice(Product product, Date date) {
        return this.rules.getProductPrice(product, "productPrice.fixedPrice", date, this.pricingGroup.getGroup());
    }

    @Override
    public ProductPrice getUnitPrice(Product product, Date date) {
        return this.rules.getProductPrice(product, "productPrice.unitPrice", date, this.pricingGroup.getGroup());
    }

    @Override
    public ProductPrice getProductPrice(String shortName, BigDecimal price, BigDecimal serviceRatio, Product product, Date date) {
        ProductPrice result = null;
        List prices = this.rules.getProductPrices(product, shortName, date, this.pricingGroup);
        for (ProductPrice p : prices) {
            if (this.getPrice(product, p, BigDecimal.ONE).compareTo(price) != 0) continue;
            result = p;
            break;
        }
        return result;
    }

    @Override
    public BigDecimal getTaxExPrice(Product product, Date date) {
        BigDecimal result = null;
        BigDecimal unitPrice = this.getPrice(this.getUnitPrice(product, date));
        BigDecimal fixedPrice = this.getPrice(this.getFixedPrice(product, date));
        if (unitPrice != null || fixedPrice != null) {
            result = MathRules.calculateTotal((BigDecimal)(fixedPrice != null ? fixedPrice : BigDecimal.ZERO), (BigDecimal)(unitPrice != null ? unitPrice : BigDecimal.ZERO), (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (int)2);
        }
        return result;
    }

    @Override
    public BigDecimal getServiceRatio(Product product, Entity department, Date date) {
        BigDecimal result = null;
        if (product != null && this.location != null) {
            result = this.serviceRatios.getServiceRatio(product, department, this.location, date);
        }
        return result;
    }

    public void setPricingGroup(PricingGroup group) {
        this.pricingGroup = group;
    }

    public PricingGroup getPricingGroup() {
        return this.pricingGroup;
    }

    protected Currency getCurrency() {
        return this.currency;
    }

    protected ProductPriceRules getRules() {
        return this.rules;
    }

    protected abstract BigDecimal getTaxRate(Product var1);

    protected PricingGroup getPricingGroup(Party location, LocationRules rules) {
        Lookup result = null;
        if (location != null) {
            result = rules.getPricingGroup(location);
        }
        return new PricingGroup(result);
    }

    private BigDecimal getPrice(ProductPrice price) {
        return price != null ? price.getPrice() : null;
    }
}

