/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.print;

import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.report.PrintProperties;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.AbstractIMPrinter;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.report.TemplatedReporter;

public abstract class TemplatedIMPrinter<T>
extends AbstractIMPrinter<T> {
    private DocumentPrinter defaultPrinter;

    public TemplatedIMPrinter(TemplatedReporter<T> reporter, PrinterContext printerContext, Context context) {
        super(reporter, printerContext, context);
        DocumentTemplate template = this.getTemplate();
        if (template != null) {
            DocumentPrinter defaultPrinter = this.getDefaultPrinter();
            boolean interactive = defaultPrinter == null || this.getInteractive(template, defaultPrinter);
            this.setInteractive(interactive);
            this.setCopies(template.getCopies());
        }
        this.setFields(ReportContextFactory.create(context));
    }

    @Override
    public String getDisplayName() {
        return ((TemplatedReporter)this.getReporter()).getDisplayName();
    }

    @Override
    public DocumentPrinter getDefaultPrinter() {
        if (this.defaultPrinter == null) {
            DocumentTemplate template = this.getTemplate();
            this.defaultPrinter = this.getDefaultPrinter(template);
        }
        return this.defaultPrinter;
    }

    @Override
    public TemplatedReporter<T> getReporter() {
        return (TemplatedReporter)super.getReporter();
    }

    @Override
    protected PrintProperties getProperties(DocumentPrinter printer) {
        return this.getProperties(printer, this.getTemplate());
    }

    protected DocumentTemplate getTemplate() {
        return ((TemplatedReporter)this.getReporter()).getTemplate();
    }
}

