/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.patient;

import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.patient.PatientResultSet;
import org.openvpms.web.component.im.query.AbstractEntityQuery;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusHelper;

public class PatientObjectSetQuery
extends AbstractEntityQuery<ObjectSet> {
    private final Party customer;
    private boolean showAllPatients;
    private CheckBox allPatients;
    private static final String ALL_PATIENTS_ID = "allpatients";

    public PatientObjectSetQuery(String[] shortNames, Context context) {
        this(shortNames, context.getCustomer());
    }

    public PatientObjectSetQuery(String[] shortNames, Party customer) {
        super(shortNames, Party.class);
        this.customer = customer;
    }

    public void setShowAllPatients(boolean show) {
        this.showAllPatients = show;
    }

    public void setQueryAllPatients(boolean all) {
        this.getAllPatients().setSelected(all);
    }

    public boolean isQueryAllPatients() {
        return this.getAllPatients().isSelected() || this.customer == null;
    }

    @Override
    public boolean isAuto() {
        return this.customer != null || this.getValue() != null;
    }

    @Override
    protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
        Reference party = this.isQueryAllPatients() ? null : (this.customer != null ? this.customer.getObjectReference() : null);
        return new PatientResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), party, this.getConstraints(), sort, this.getMaxResults());
    }

    @Override
    protected void doLayout(Component container) {
        this.addShortNameSelector(container);
        this.addSearchField(container);
        this.addIdentitySearch(container);
        if (this.showAllPatients) {
            this.addAllPatients(container);
        }
        this.addActive(container);
        FocusHelper.setFocus((Component)this.getSearchField());
    }

    protected void addAllPatients(Component container) {
        CheckBox box = this.getAllPatients();
        Label label = LabelFactory.create((String)ALL_PATIENTS_ID);
        container.add((Component)label);
        container.add((Component)box);
        this.getFocusGroup().add((Component)box);
    }

    private CheckBox getAllPatients() {
        if (this.allPatients == null) {
            this.allPatients = CheckBoxFactory.create();
            this.allPatients.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                }
            });
            boolean selected = this.customer == null;
            this.allPatients.setSelected(selected);
        }
        return this.allPatients;
    }
}

