/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertion;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionFactory;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.web.component.im.lookup.AbstractLookupQuery;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.system.ServiceHelper;

public class NodeLookupQuery
extends AbstractLookupQuery {
    private final String[] codes;
    private String shortName;
    private String node;
    private IMObject object;
    private NodeDescriptor descriptor;

    public NodeLookupQuery(String shortName, String node) {
        this(shortName, node, null);
    }

    public NodeLookupQuery(String shortName, String node, String ... codes) {
        this.shortName = shortName;
        this.node = node;
        this.codes = codes;
    }

    public NodeLookupQuery(IMObject object, Property property) {
        this(object, property.getDescriptor());
    }

    public NodeLookupQuery(IMObject object, NodeDescriptor descriptor) {
        this.object = object;
        this.descriptor = descriptor;
        this.codes = null;
    }

    @Override
    public List<Lookup> getLookups() {
        List<Lookup> result = Collections.emptyList();
        try {
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            LookupService lookupService = ServiceHelper.getLookupService();
            NodeDescriptor node = this.getDescriptor();
            if (node != null) {
                LookupAssertion assertion = LookupAssertionFactory.create((NodeDescriptor)node, (ArchetypeService)service, (LookupService)lookupService);
                ArrayList<Lookup> lookups = this.object != null ? new ArrayList<Lookup>(assertion.getLookups(this.object)) : assertion.getLookups();
                if (this.codes != null && this.codes.length > 0) {
                    result = new ArrayList<Lookup>();
                    for (String code : this.codes) {
                        Lookup lookup = this.getLookup(code, lookups);
                        if (lookup == null) continue;
                        result.add(lookup);
                    }
                } else {
                    result = lookups;
                }
            }
        }
        catch (OpenVPMSException error) {
            ErrorHelper.show(error);
        }
        this.sort(result);
        return result;
    }

    @Override
    public Lookup getDefault() {
        Lookup result = null;
        NodeDescriptor node = this.getDescriptor();
        if (node != null) {
            List<Lookup> lookups = this.getLookups();
            String code = node.getDefaultValue();
            if (code != null) {
                code = StringUtils.strip((String)code, (String)"'");
                result = this.getLookup(code, lookups);
            }
            if (result == null) {
                result = this.getDefault(lookups);
            }
        }
        return result;
    }

    private NodeDescriptor getDescriptor() {
        IArchetypeService archetypeService;
        ArchetypeDescriptor archetype;
        if (this.descriptor == null && this.shortName != null && (archetype = (archetypeService = ArchetypeServiceHelper.getArchetypeService()).getArchetypeDescriptor(this.shortName)) != null) {
            this.descriptor = archetype.getNodeDescriptor(this.node);
        }
        return this.descriptor;
    }
}

