/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.DescriptorTableModel;

public class LookupTableModel
extends DescriptorTableModel<Lookup> {
    private final boolean active;

    public LookupTableModel(String[] shortNames, LayoutContext context) {
        this(shortNames, null, context);
    }

    public LookupTableModel(String[] shortNames, Query<Lookup> query, LayoutContext context) {
        super(context);
        this.active = query == null || query.getActive() == BaseArchetypeConstraint.State.BOTH;
        this.setTableColumnModel(this.createColumnModel(shortNames, context));
    }

    @Override
    protected List<String> getNodeNames(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        List<String> result;
        List<String> names = super.getNodeNames(archetypes, context);
        if (archetypes.size() > 1 && names.size() < 2) {
            result = new ArrayList<String>();
            this.include("id", result, names, false);
            this.include("code", result, names, false);
            this.include("name", result, names, true);
            this.include("description", result, names, true);
            if (this.active) {
                this.include("active", result, names, true);
            }
            result.addAll(names);
        } else {
            result = names;
            if (!this.active) {
                names.remove("active");
            }
        }
        return result;
    }

    private void include(String name, List<String> target, List<String> source, boolean required) {
        if (source.contains(name)) {
            target.add(name);
            source.remove(name);
        } else if (required) {
            target.add(name);
        }
    }
}

