/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.List;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.lookup.ListLookupQuery;
import org.openvpms.web.component.im.lookup.LookupQuery;

public class LookupField
extends SelectField {
    public LookupField(List<Lookup> lookups, boolean all) {
        this(new LookupListModel(new ListLookupQuery(lookups), all));
    }

    public LookupField(LookupQuery source) {
        this(source, false);
    }

    public LookupField(LookupQuery source, boolean all) {
        this(source, all, false);
    }

    public LookupField(LookupQuery source, boolean all, boolean none) {
        this(new LookupListModel(source, all, none));
    }

    public LookupField(LookupListModel model) {
        super((ListModel)model);
        this.setCellRenderer(LookupListCellRenderer.INSTANCE);
    }

    public String getSelectedCode() {
        Lookup selected = this.getSelected();
        return selected != null ? selected.getCode() : null;
    }

    public Lookup getSelected() {
        int index = this.getSelectedIndex();
        if (index != -1) {
            LookupListModel model = this.getModel();
            return model.getLookup(index);
        }
        return null;
    }

    public void setSelected(Lookup lookup) {
        String code = lookup != null ? lookup.getCode() : null;
        this.setSelected(code);
    }

    public void setSelected(String code) {
        LookupListModel model = this.getModel();
        this.setSelectedIndex(model.indexOf(code));
    }

    public LookupListModel getModel() {
        return (LookupListModel)super.getModel();
    }

    public boolean refresh() {
        LookupListModel model = this.getModel();
        boolean refreshed = model.refresh();
        if (refreshed) {
            this.setDefaultSelection();
        }
        return refreshed;
    }

    protected void setDefaultSelection() {
        LookupListModel model = this.getModel();
        Lookup lookup = model.getDefaultLookup();
        if (lookup != null) {
            this.setSelected(lookup);
        } else if (model.getAllIndex() != -1) {
            this.setSelectedIndex(model.getAllIndex());
        } else if (model.getNoneIndex() != -1) {
            this.setSelectedIndex(model.getNoneIndex());
        } else if (model.getDefaultIndex() != -1) {
            this.setSelectedIndex(model.getDefaultIndex());
        } else {
            this.getSelectionModel().clearSelection();
        }
    }
}

