/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.list;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.web.component.im.list.AllNoneListModel;

public class ObjectListModel<T>
extends AllNoneListModel {
    private final boolean addAll;
    private final boolean addNone;
    private final boolean addDefault;
    private List<T> objects;

    public ObjectListModel() {
        this(false, false);
    }

    public ObjectListModel(boolean addAll, boolean addNone) {
        this(new ArrayList(), addAll, addNone);
    }

    public ObjectListModel(List<? extends T> objects, boolean addAll, boolean addNone) {
        this(objects, addAll, addNone, false);
    }

    public ObjectListModel(List<? extends T> objects, boolean addAll, boolean addNone, boolean addDefault) {
        this.addAll = addAll;
        this.addNone = addNone;
        this.addDefault = addDefault;
        this.setObjects(objects);
    }

    public T getObject(int index) {
        return this.objects.get(index);
    }

    public int indexOf(T object) {
        return this.objects.indexOf(object);
    }

    public List<T> getObjects() {
        return this.objects;
    }

    public void setObjects(List<? extends T> objects) {
        this.initObjects(objects);
        this.fireContentsChanged(0, objects.size());
    }

    public int size() {
        return this.objects.size();
    }

    public Object get(int index) {
        return this.getObject(index);
    }

    protected void initObjects(List<? extends T> objects) {
        int index = 0;
        this.objects = new ArrayList<T>();
        if (this.addAll) {
            this.objects.add(null);
            this.setAll(index++);
        }
        if (this.addNone) {
            this.objects.add(null);
            this.setNone(index++);
        }
        if (this.addDefault) {
            this.objects.add(null);
            this.setDefaultIndex(index);
        }
        this.objects.addAll(objects);
    }
}

