/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.layout;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.RowLayoutData;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonColumn;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public abstract class PrintObjectLayoutStrategy
extends AbstractLayoutStrategy {
    private final String buttonId;
    private Button button;
    private boolean enableButton = true;

    public PrintObjectLayoutStrategy(String buttonId) {
        this.buttonId = buttonId;
    }

    public void setEnableButton(boolean enable) {
        this.enableButton = enable;
    }

    @Override
    protected void doLayout(final IMObject object, PropertySet properties, IMObject parent, Component container, final LayoutContext context) {
        if (this.enableButton) {
            this.button = this.createButton(this.buttonId);
            this.button.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    PrintObjectLayoutStrategy.this.onPrint(object, context.getContext(), context.getHelpContext());
                }
            });
        }
        super.doLayout(object, properties, parent, container, context);
        if (this.enableButton) {
            this.getFocusGroup().add((Component)this.button);
        }
    }

    protected Button createButton(String buttonId) {
        return ButtonFactory.create((String)buttonId);
    }

    @Override
    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        if (this.button != null) {
            ComponentGrid grid = this.createGrid(object, properties, context);
            this.addAuditInfo(object, grid, context);
            ButtonColumn column = new ButtonColumn(this.getFocusGroup());
            RowLayoutData layoutData = new RowLayoutData();
            layoutData.setAlignment(Alignment.ALIGN_TOP);
            column.setLayoutData((LayoutData)layoutData);
            this.addButton(column.getButtons());
            Row row = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.createGrid(grid), column});
            container.add((Component)ColumnFactory.create((String)"Inset.Small", (Component[])new Component[]{row}));
        } else {
            super.doSimpleLayout(object, parent, properties, container, context);
        }
    }

    protected void addButton(ButtonSet set) {
        set.add(this.button);
    }

    protected void onPrint(IMObject object, Context context, HelpContext help) {
        try {
            DocumentTemplateLocator locator = this.createDocumentTemplateLocator(object, context);
            IMPrinterFactory factory = ServiceHelper.getBean(IMPrinterFactory.class);
            IMPrinter<IMObject> printer = factory.create(object, locator, context);
            InteractiveIMPrinter<IMObject> iPrinter = new InteractiveIMPrinter<IMObject>(printer, context, help);
            iPrinter.print();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    protected DocumentTemplateLocator createDocumentTemplateLocator(IMObject object, Context context) {
        return new ContextDocumentTemplateLocator(object, context);
    }
}

