/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.layout;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.layout.ColumnLayoutData;
import nextapp.echo2.app.layout.RowLayoutData;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.filter.ComplexNodeFilter;
import org.openvpms.web.component.im.filter.NodeFilter;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;

public class ExpandableLayoutStrategy
extends AbstractLayoutStrategy {
    private final boolean showButton;
    private boolean showOptional;
    private Button button;

    public ExpandableLayoutStrategy() {
        this(false, true);
    }

    public ExpandableLayoutStrategy(boolean showOptional) {
        this(showOptional, true);
    }

    public ExpandableLayoutStrategy(boolean showOptional, boolean showButton) {
        this.showOptional = showOptional;
        this.showButton = showButton;
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        this.button = null;
        return super.apply(object, properties, parent, context);
    }

    public Button getButton() {
        return this.button;
    }

    public boolean isShowOptional() {
        return this.showOptional;
    }

    public void setShowOptional(boolean showOptional) {
        this.showOptional = showOptional;
    }

    @Override
    protected void doLayout(IMObject object, PropertySet properties, IMObject parent, Component container, LayoutContext context) {
        super.doLayout(object, properties, parent, container, context);
        if (this.button == null && this.showButton) {
            Row row = this.getButtonRow();
            ColumnLayoutData right = new ColumnLayoutData();
            right.setAlignment(new Alignment(5, 6));
            row.setLayoutData((LayoutData)right);
            container.add((Component)row);
        }
    }

    @Override
    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        if (this.button != null || !this.showButton) {
            super.doSimpleLayout(object, parent, properties, container, context);
        } else if (!properties.isEmpty()) {
            Row group = RowFactory.create();
            super.doSimpleLayout(object, parent, properties, (Component)group, context);
            group.add((Component)this.getButtonRow());
            container.add((Component)group);
        }
    }

    @Override
    protected void doComplexLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        if (this.button == null && this.showButton && !properties.isEmpty()) {
            Row row = this.getButtonRow();
            ColumnLayoutData right = new ColumnLayoutData();
            right.setAlignment(new Alignment(5, 6));
            row.setLayoutData((LayoutData)right);
            container.add((Component)row);
        }
        super.doComplexLayout(object, parent, properties, container, context);
    }

    @Override
    protected NodeFilter getNodeFilter(IMObject object, LayoutContext context) {
        return new ComplexNodeFilter(this.showOptional, false);
    }

    protected boolean showButton() {
        return this.showButton;
    }

    protected Row getButtonRow() {
        String key = this.showOptional ? "minus" : "plus";
        this.button = ButtonFactory.create((String)key);
        RowLayoutData right = new RowLayoutData();
        right.setAlignment(new Alignment(5, 6));
        right.setWidth(new Extent(100, 2));
        this.button.setLayoutData((LayoutData)right);
        Row wrapper = new Row();
        wrapper.add((Component)this.button);
        wrapper.setLayoutData((LayoutData)right);
        return wrapper;
    }
}

