/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.reminder;

import java.util.Date;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.system.ServiceHelper;

public class ReminderItemEditor
extends AbstractActEditor {
    private ReminderConfiguration configuration;

    public ReminderItemEditor(Act act, Act parent, LayoutContext context) {
        super(act, (IMObject)parent, context);
        if (act.isNew() && parent != null) {
            Date dueDate = parent.getActivityStartTime();
            if (dueDate != null) {
                this.setEndTime(dueDate);
            }
            IMObjectBean bean = this.getBean((IMObject)parent);
            this.getProperty("count").setValue(bean.getInt("reminderCount"));
        }
    }

    @Override
    public void setEndTime(Date time) {
        super.setEndTime(time);
        Date dueDate = this.getEndTime();
        if (dueDate != null) {
            this.setStartTime(this.getSendDate(dueDate), true);
        }
    }

    public int getCount() {
        return this.getProperty("count").getInt();
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
    }

    private Date getSendDate(Date dueDate) {
        Date result = null;
        ReminderConfiguration config = this.getReminderConfiguration();
        if (config != null) {
            String archetype = this.getObject().getArchetype();
            result = config.getSendDate(dueDate, archetype);
        }
        return result;
    }

    private ReminderConfiguration getReminderConfiguration() {
        Party practice;
        if (this.configuration == null && (practice = this.getLayoutContext().getContext().getPractice()) != null) {
            this.configuration = ServiceHelper.getBean(ReminderRules.class).getConfiguration(practice);
        }
        return this.configuration;
    }
}

