/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.reminder;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.reminder.ReminderItemEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientActEditor;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ReminderEditor
extends PatientActEditor {
    private final ReminderRules rules;
    private boolean markCompleted = true;

    public ReminderEditor(Act act, Act parent, LayoutContext context) {
        super(act, parent, context);
        if (!act.isA("act.patientReminder")) {
            throw new IllegalArgumentException("Invalid act type:" + act.getArchetype());
        }
        if (!UserHelper.isAdmin(context.getContext().getUser())) {
            ActRelationshipCollectionEditor items = new ActRelationshipCollectionEditor(this.getCollectionProperty("items"), act, context){

                @Override
                protected boolean canAdd() {
                    return false;
                }
            };
            this.addEditor(items);
        }
        this.addStartEndTimeListeners();
        this.rules = ServiceHelper.getBean(ReminderRules.class);
    }

    public void setInitialTime(Date initial) {
        this.getProperty("initialTime").setValue(initial);
    }

    public Date getInitialTime() {
        return this.getProperty("initialTime").getDate();
    }

    public void setReminderType(Entity reminderType) {
        this.setParticipant("reminderType", reminderType);
    }

    public Entity getReminderType() {
        return this.getParticipant("reminderType");
    }

    public void setProduct(Product product) {
        this.setParticipant("product", (Entity)product);
    }

    public Product getProduct() {
        return (Product)this.getParticipant("product");
    }

    public int getReminderCount() {
        return this.getProperty("reminderCount").getInt();
    }

    public void setMarkMatchingRemindersCompleted(boolean markCompleted) {
        this.markCompleted = markCompleted;
    }

    @Override
    public void setClinician(User clinician) {
        super.setClinician(clinician);
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        ActRelationshipCollectionEditor items = this.getItems();
        if (items != null) {
            strategy.addComponent(new ComponentState(items));
        }
        return strategy;
    }

    @Override
    protected void onLayoutCompleted() {
        ActRelationshipCollectionEditor items;
        Editor reminderType = this.getEditor("reminderType");
        if (reminderType != null) {
            ModifiableListener listener = new ModifiableListener(){

                @Override
                public void modified(Modifiable modifiable) {
                    ReminderEditor.this.onReminderTypeChanged();
                }
            };
            reminderType.addModifiableListener(listener);
        }
        if ((items = this.getItems()) != null) {
            items.setExcludeDefaultValueObject(false);
        }
    }

    @Override
    protected void onStartTimeChanged() {
        this.updateReminderItemSendDates();
    }

    @Override
    protected void onEndTimeChanged() {
        Entity reminderType;
        Date dueDate = this.getEndTime();
        if (dueDate != null && (reminderType = this.getReminderType()) != null) {
            Date nextReminderDate = this.getNextReminderDate(reminderType, dueDate);
            this.setStartTime(nextReminderDate);
        }
    }

    @Override
    protected void doSave() {
        boolean isNew = this.getObject().isNew();
        super.doSave();
        if (this.markCompleted && isNew) {
            this.rules.markMatchingRemindersCompleted(this.getObject());
        }
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean valid = super.doValidation(validator);
        if (valid) {
            valid = this.validateItems(validator);
        }
        return valid;
    }

    @Override
    protected boolean validateStartEndTimes(Validator validator) {
        return true;
    }

    private void updateReminderItemSendDates() {
        ActRelationshipCollectionEditor items = this.getItems();
        if (items != null) {
            Date start = this.getStartTime();
            int count = this.getReminderCount();
            for (Act item : items.getCurrentActs()) {
                ReminderItemEditor itemEditor;
                IMObjectEditor editor = items.getEditor((IMObject)item);
                if (!(editor instanceof ReminderItemEditor) || (itemEditor = (ReminderItemEditor)editor).getCount() != count) continue;
                itemEditor.setEndTime(start);
            }
        }
    }

    private boolean validateItems(Validator validator) {
        List<Act> acts;
        boolean valid = true;
        ActRelationshipCollectionEditor items = this.getItems();
        if (items != null && (acts = items.getCurrentActs()).size() > 1) {
            HashMap<Integer, Set> map = new HashMap<Integer, Set>();
            for (Act act : acts) {
                String archetype;
                IMObjectBean bean = this.getBean((IMObject)act);
                int count = bean.getInt("count");
                Set set = map.computeIfAbsent(count, k -> new HashSet());
                if (set.contains(archetype = act.getArchetype())) {
                    String message = Messages.format((String)"patient.reminder.duplicateItem", (Object[])new Object[]{this.getDisplayName(archetype), count});
                    validator.add((Modifiable)this, new ValidatorError(message));
                    valid = false;
                    break;
                }
                set.add(archetype);
            }
        }
        return valid;
    }

    private void onReminderTypeChanged() {
        try {
            Date initial = this.getInitialTime();
            Entity reminderType = this.getReminderType();
            if (initial != null && reminderType != null) {
                Date dueDate = this.rules.calculateReminderDueDate(initial, reminderType);
                this.setEndTime(dueDate);
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    private Date getNextReminderDate(Entity reminderType, Date dueDate) {
        Date next = this.rules.getNextReminderDate(dueDate, reminderType, this.getReminderCount());
        if (next == null) {
            next = dueDate;
        }
        return next;
    }

    private ActRelationshipCollectionEditor getItems() {
        return (ActRelationshipCollectionEditor)this.getEditor("items", false);
    }
}

