/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.payment;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.MutablePropertySet;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;

public abstract class PaymentItemEditor
extends AbstractActEditor {
    protected static final String AMOUNT = "amount";
    private boolean readOnlyAmount;
    private static final String ROUNDED_AMOUNT = "roundedAmount";
    private static final String TENDERED = "tendered";

    public PaymentItemEditor(FinancialAct act, FinancialAct parent, LayoutContext context) {
        super((Act)act, (IMObject)parent, context);
        if (act.isNew() && parent != null) {
            act.setActivityStartTime(parent.getActivityStartTime());
        }
        if (this.getProperty(ROUNDED_AMOUNT) != null) {
            Property amount = this.getProperty(AMOUNT);
            amount.addModifiableListener(modifiable -> this.onAmountChanged());
            if (act.isNew()) {
                this.onAmountChanged();
            }
        }
    }

    public BigDecimal getAmount() {
        return this.getProperty(AMOUNT).getBigDecimal(BigDecimal.ZERO);
    }

    public void setAmount(BigDecimal amount) {
        this.getProperty(AMOUNT).setValue(amount);
    }

    public void setReadOnlyAmount(boolean readOnly) {
        if (this.readOnlyAmount != readOnly) {
            this.readOnlyAmount = readOnly;
            if (this.getView().hasComponent()) {
                this.onLayout();
            }
        }
    }

    public boolean supportsSplitTransactions() {
        return true;
    }

    public boolean canDelete() {
        return true;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        if (this.readOnlyAmount) {
            return new LayoutStrategy();
        }
        return super.createLayoutStrategy();
    }

    @Override
    protected boolean validateStartEndTimes(Validator validator) {
        return true;
    }

    private void onAmountChanged() {
        try {
            BigDecimal amount;
            BigDecimal rounded = amount = (BigDecimal)this.getProperty(AMOUNT).getValue();
            Property roundedAmount = this.getProperty(ROUNDED_AMOUNT);
            Currency currency = ContextHelper.getPracticeCurrency(this.getLayoutContext().getContext());
            if (currency != null) {
                rounded = currency.roundCash(amount);
            }
            roundedAmount.setValue(rounded);
            Property tenderedAmount = this.getProperty(TENDERED);
            if (tenderedAmount != null) {
                tenderedAmount.setValue(rounded);
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    private class LayoutStrategy
    extends AbstractLayoutStrategy {
        private LayoutStrategy() {
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            if (PaymentItemEditor.this.readOnlyAmount) {
                MutablePropertySet set = new MutablePropertySet(properties);
                set.setReadOnly(PaymentItemEditor.AMOUNT);
                properties = set;
            }
            return super.apply(object, properties, parent, context);
        }
    }
}

