/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.payment;

import java.math.BigDecimal;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.account.AccountActEditor;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;

public abstract class PaymentEditor
extends AccountActEditor {
    public PaymentEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
    }

    public PaymentItemEditor addItem() {
        return this.addItem(null);
    }

    public PaymentItemEditor addItem(String archetype) {
        ActRelationshipCollectionEditor items = this.getItems();
        PaymentItemEditor result = (PaymentItemEditor)(archetype != null ? items.add(archetype) : items.add());
        if (result != null && items.getCurrentEditor() == result) {
            this.getFocusGroup().setDefault(result.getFocusGroup().getDefaultFocus());
        }
        return result;
    }

    public PaymentItemEditor getCurrentItem() {
        return (PaymentItemEditor)this.getItems().getCurrentEditor();
    }

    public PaymentItemEditor getUnsavedItem() {
        return this.getUnsavedItem(null);
    }

    public PaymentItemEditor getUnsavedItem(String archetype) {
        Act object;
        PaymentItemEditor editor = this.getCurrentItem();
        Act act = object = editor != null ? editor.getObject() : null;
        if (object == null || !object.isNew()) {
            editor = this.addItem(archetype);
        } else if (object.isNew() && archetype != null && !object.isA(archetype)) {
            this.getItems().remove((IMObject)object);
            editor = this.addItem(archetype);
        }
        return editor;
    }

    @Override
    protected void onItemsChanged() {
        Property amount = this.getProperty("amount");
        BigDecimal value = ActHelper.sum((Act)this.getObject(), this.getItems().getCurrentActs(), "amount");
        amount.setValue(value);
    }
}

